/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.periodtrend;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.misc.ConfigShift;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.periodtrend.PeriodTrendReportCompiler;
import ordermate.database.searchers.reports.sales.time.SalesHistoryReportSearcher;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class PeriodTrendReportProvider
extends AbstractReportProvider {
    private ReportBuilder builder;
    private PeriodTrendReportCompiler compiler;

    public PeriodTrendReportProvider() {
        this(new PeriodTrendReportCompiler(new SalesHistoryReportSearcher(PeriodReportAdapter.MONTHLY)));
    }

    public PeriodTrendReportProvider(PeriodTrendReportCompiler yourCompiler) {
        this.compiler = yourCompiler;
    }

    public PeriodTrendReportCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRTableModelDataSource(this.compiler.compile());
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        this.builder = new ReportBuilder();
        TableModel model = this.compiler.compile();
        this.initBuilder(model);
        return this.builder;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.builder = new ReportBuilder();
        TableModel model = this.compiler.compile();
        this.initBuilder(model);
        DynamicReport report = this.builder.buildJasperReport();
        return report;
    }

    private void initBuilder(TableModel model) throws ColumnBuilderException {
        this.makeTitle(model);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            SimpleColumn col;
            if (i == 0) {
                col = JasperReportHelper.createSimpleColumn(model.getColumnName(i), String.class);
                col.setStyle(JasperReportHelper.leftAlignStyle(col.getStyle()));
            } else {
                String colName = model.getColumnName(i);
                col = JasperReportHelper.createSimpleColumn(colName, String.class);
                col.setTitle(model.getColumnName(i));
                col.setStyle(JasperReportHelper.rightAlignStyle(col.getStyle()));
                col.setBlankWhenNull(Boolean.TRUE);
            }
            this.builder.getReportBuilder().addColumn((AbstractColumn)col);
        }
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
    }

    private void makeTitle(TableModel model) {
        List<SalesLocation> locs;
        PeriodReportAdapter period = this.compiler.getPeriod();
        StringBuilder SB = new StringBuilder(period.getLabel());
        SB.append(" Period Trend ").append(this.compiler.isCumulative() ? "Cumulative Report" : "Report");
        this.builder.setTitle(SB.toString());
        SB = new StringBuilder("Last ");
        SB.append(String.valueOf(model.getColumnCount() - 2)).append(" ").append(this.compiler.getPeriod().getUnitOfTime()).append("s to ");
        SB.append(period.formatDateForDisplay(this.compiler.getDateRangeFilter().getEnd()));
        SB.append(" by ");
        int minutes = this.compiler.getMinuteFactor();
        if (minutes >= 60) {
            if ((minutes /= 60) == 1) {
                SB.append("Hour");
            } else {
                SB.append(minutes).append(" Hours");
            }
        } else if (minutes == 1) {
            SB.append("Minute");
        } else {
            SB.append(this.compiler.getMinuteFactor()).append(" Minutes");
        }
        Date dayOfWeek = (Date)this.compiler.getSearcher().getDayOfWeekFilter().getSearchValue();
        List<ConfigShift> shifts = this.compiler.getSearcher().getShiftFilter().getSelectedOptions();
        if (dayOfWeek != null) {
            SB.append(" ").append(new SimpleDateFormat("EEE").format(dayOfWeek));
        }
        if (shifts != null && !shifts.isEmpty()) {
            SB.append(" Shift: ");
            SB.append(StringUtils.mergeToStringWithSeparator(shifts, ", ", null));
        }
        if ((locs = this.compiler.getSearcher().getSalesLocationFilter().getSelectedOptions()) != null && !locs.isEmpty()) {
            SB.append(" ").append("Sales Location").append(": ").append(StringUtils.mergeToStringWithSeparator(locs, ",", null));
        }
        this.builder.setSubtitle(SB.toString());
    }

    @Override
    protected String getAdditionalFooterText() {
        String trims = ReportProperty.find(ReportGroup.PeriodTrend, PeriodTrendReportCompiler.TRIM_BLOCK).getStringValue(null);
        if (trims != null) {
            return "This report is filtered to show only " + trims.replaceAll(",", " to ");
        }
        return null;
    }
}

