/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.plus;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.sales.general.PlusesSoldReport;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.searchers.reports.sales.general.PlusesSoldReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;
import ordermate.reports.printing.HeaderSubReport;

public class PlusesReportProvider
extends AbstractReportProvider {
    private PlusesSoldReportSearcher searcher;
    private ReportBuilder builder;
    private User user;
    static final String PLUS_ID_NAME = "Plus ID";
    static final String PLUS_GROUP_NAME = "Plus Group";
    static final String PLUS_GROUP_SIZE = "Size";
    static final String PLUS_NAME = "Plus Name";
    static final String AVERAGE_PRICE = "Price";
    static final String QUANTITY = "Quantity";
    static final String TOTAL_PRICE = "Sales";
    private List<PlusesSoldReport> currentReportItems;
    private SearcherDataSourceProvider<PlusesSoldReportSearcher> searcherDataSourceProvider;
    private PeriodReportAdapter periodReportAdapter;

    public PlusesReportProvider(PlusesSoldReportSearcher searcher) {
        this.searcherDataSourceProvider = new SearcherDataSourceProvider<PlusesSoldReportSearcher>(searcher);
        this.periodReportAdapter = searcher.getPeriod();
        this.searcher = searcher;
    }

    public String getReportTitle() {
        return "Pluses Sold";
    }

    public TimeSearchFilter getTimeFilter() {
        return this.searcher.getTimeSearchFilter();
    }

    protected String getSubTitle() {
        String time;
        StringBuilder SB = new StringBuilder(this.getDateString());
        TimeSearchFilter timeFilter = this.getTimeFilter();
        ReportProviderHelper helper = new ReportProviderHelper();
        if (timeFilter != null && !StringUtils.isEmpty(time = timeFilter.getDisplayableTime())) {
            helper.appendSubTitleAndValue(SB, "Day Part", time);
        }
        helper.appendSearchFilter(SB, PLUS_GROUP_NAME, this.searcher.getAddGroupFilter());
        helper.appendSearchFilter(SB, PLUS_GROUP_SIZE, this.searcher.getSizeFilter());
        helper.appendSearchFilter(SB, "Text Search", this.searcher.getTextFilter());
        helper.appendSearchFilter(SB, "Sales Location", this.searcher.getSalesLocationFilter());
        return SB.toString();
    }

    protected String getDateString() {
        IRangedSearchFilter dateRangeFilter = this.searcher.getTradingDayDateRangeFilter();
        IRangedSearchFilter dateRangeAdapter = null;
        try {
            dateRangeAdapter = (IRangedSearchFilter)this.searcher.getClass().getMethod("getTradingDayDateRangeAdapter", null).invoke((Object)this.searcher, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String dateString = this.periodReportAdapter == null && dateRangeAdapter == null ? TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(dateRangeFilter) : (this.periodReportAdapter == null && dateRangeAdapter != null ? TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(dateRangeAdapter) : (dateRangeAdapter != null ? this.periodReportAdapter.formatTradingDayRangeForDisplay((Date)dateRangeFilter.getStart(), (Date)dateRangeFilter.getEnd(), (Date)dateRangeAdapter.getEnd()) : this.periodReportAdapter.formatRangeForDisplay((Date)dateRangeFilter.getStart(), (Date)dateRangeFilter.getEnd())));
        return dateString;
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.searcher.getTradingDayDateRangeFilter());
    }

    protected void addReportColumns(ReportBuilder toInitialise) throws BuilderException {
        ArrayList<PropertiedObject.Property> propList = new ArrayList<PropertiedObject.Property>(Arrays.asList(PlusesSoldReport.Properties.PLUS_GROUP_NAME, PlusesSoldReport.Properties.PLUS_GROUP_SIZE, PlusesSoldReport.Properties.PLUS_NAME, PlusesSoldReport.Properties.AVERAGE_PRICE, PlusesSoldReport.Properties.QUANTITY, PlusesSoldReport.Properties.TOTAL_PRICE));
        ArrayList<String> titles = new ArrayList<String>(Arrays.asList(PLUS_GROUP_NAME, PLUS_GROUP_SIZE, PLUS_NAME, AVERAGE_PRICE, QUANTITY, TOTAL_PRICE));
        if (ExperimentalFeatureHelper.isShowItemIds()) {
            propList.add(2, PlusesSoldReport.Properties.PLUS_ID);
            titles.add(2, PLUS_ID_NAME);
        }
        toInitialise.addReportColumns(propList, titles.toArray(new String[titles.size()]));
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        this.builder = null;
        if (this.builder == null || this.builder.getColumnCount() == 0) {
            this.builder = new ReportBuilder();
            this.initBuilder(this.builder);
        }
        this.builder.getPropertyColumn(PlusesSoldReport.Properties.QUANTITY).setPattern("0");
        this.builder.getPropertyColumn(PlusesSoldReport.Properties.TOTAL_PRICE).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        this.builder.getPropertyColumn(PlusesSoldReport.Properties.AVERAGE_PRICE).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        return this.builder;
    }

    private synchronized void initBuilder(ReportBuilder toInitialise) throws BuilderException {
        toInitialise.addBusinessLogoDetailHeaderAndFooterTemplate();
        this.getParameters().putAll(new HeaderSubReport().getParamsMap());
        if (this.user != null) {
            this.addParam("user", this.user.getName());
        }
        toInitialise.setTitle(this.getReportTitle());
        toInitialise.setSubtitle(this.getSubTitle());
        this.addReportColumns(toInitialise);
        ArrayList<ReportBuilder.PropertyCalculation> calcs = new ArrayList<ReportBuilder.PropertyCalculation>();
        calcs.add(new ReportBuilder.PropertyCalculation(PlusesSoldReport.Properties.TOTAL_PRICE, DJCalculation.SUM));
        toInitialise.addGroupBy(PlusesSoldReport.Properties.PLUS_GROUP_NAME, calcs);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        this.currentReportItems = this.searcher.search();
        return new JRBeanCollectionDataSource(this.currentReportItems);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    public void setUser(User theUser) {
        this.user = theUser;
    }
}

