/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.productivity;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.users.User;

public class ProductivityReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Date tradingDay;
    private Reference<User> user;
    private Price salesTotal;
    private Integer patronTotal;

    public ProductivityReport() {
        this.user = this.createReference(ProductivityReport.Properties.USER);
    }

    public ProductivityReport(Date tradingDay, User user, Price salesTotal, Integer partonTotal) {
        this.user = this.createReference(ProductivityReport.Properties.USER);
        this.tradingDay = tradingDay;
        this.user.set(user);
        this.salesTotal = salesTotal;
        this.patronTotal = partonTotal;
    }

    public Date getTradingDay() {
        return this.tradingDay;
    }

    public void setTradingDay(Date tradingDay) {
        this.tradingDay = tradingDay;
    }

    public User getUser() {
        return this.user.get();
    }

    public void setUser(User user) {
        this.user.set(user);
    }

    public Price getSalesTotal() {
        return this.salesTotal;
    }

    public void setSalesTotal(Price salesTotal) {
        this.salesTotal = salesTotal;
    }

    public Integer getPatronTotal() {
        return this.patronTotal;
    }

    public void setPatronTotal(Integer patronTotal) {
        this.patronTotal = patronTotal;
    }

    public Price getSalesPerPatron() {
        return this.salesTotal.divide(this.patronTotal);
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property TRADING_DAY;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property SALES_TOTAL;
        public PropertiedObject.Property PATRON_TOTAL;
        public PersistentObject.DerivedProperty SALES_PER_PATRON = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ProductivityReport.class), "salesPerPatron");
    }
}

