/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.productivity;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.constants.Rotation;
import ar.com.fdvs.dj.domain.constants.Stretching;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.searchers.reports.productivity.ProductivityReportCompiler;
import ordermate.database.searchers.reports.productivity.ProductivityReportSearcher;
import ordermate.reports.dynamicjasper.OrderMateDefaultReportStyle;
import ordermate.reports.dynamicjasper.OrdermateSmallTextReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.GenericBiListTableModel;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class ProductivityReportProvider
extends AbstractReportProvider {
    private SearcherDataSourceProvider searcherDataSourceProvider;
    ProductivityReportCompiler compiler;
    private static final String DATA_PATH = "User Tables Detailed";
    private static final String AVG_PATH = "User Tables Summary by Trading Day";
    private static final String USER_AVG_PATH = "User Tables Summary by User";
    private boolean isSplitFlag = true;

    public void setIsSpliteFlag(boolean isSpliteFlag) {
        this.isSplitFlag = isSpliteFlag;
        this.compiler.setIsSpliteFlag(isSpliteFlag);
    }

    public ProductivityReportProvider(ProductivityReportSearcher fromTableState, boolean isSpliteFlag) {
        this.isSplitFlag = isSpliteFlag;
        this.searcherDataSourceProvider = new SearcherDataSourceProvider<ProductivityReportSearcher>(fromTableState);
        this.compiler = new ProductivityReportCompiler(fromTableState);
        this.compiler.setIsSpliteFlag(isSpliteFlag);
    }

    public ProductivityReportProvider(ProductivityReportSearcher fromTableState) {
        this.searcherDataSourceProvider = new SearcherDataSourceProvider<ProductivityReportSearcher>(fromTableState);
        this.compiler = new ProductivityReportCompiler(fromTableState);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.compiler.getSearcherData());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        this.compiler.buildData();
        if (this.isSplitFlag) {
            for (int i = 0; i < this.compiler.getColumnNamesCount(); ++i) {
                this.addParam(DATA_PATH + i, new JRTableModelDataSource(new GenericBiListTableModel(this.compiler.getColumnNames(i), this.compiler.getData(i))));
            }
        } else {
            this.addParam(DATA_PATH, new JRTableModelDataSource(new GenericBiListTableModel(this.compiler.getColumnNames(0), this.compiler.getData(0))));
        }
        this.addParam(USER_AVG_PATH, new JRTableModelDataSource(new GenericBiListTableModel(this.compiler.getUserSummaryColumnNames(), this.compiler.getUserSummaryData())));
        this.addParam(AVG_PATH, new JRTableModelDataSource(new GenericBiListTableModel(this.compiler.getTradingDaySummaryColumnNames(), this.compiler.getTradingDaySummaryData())));
        ReportBuilder builder = new ReportBuilder(new OrdermateSmallTextReportStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("User Tables Report");
        ProductivityReportSearcher reportSearcher = (ProductivityReportSearcher)this.searcherDataSourceProvider.getSearch();
        IRangedQuerySearchFilter<Date> dateFilter = reportSearcher.getTradingDayDateRangeAdapter();
        StringBuilder subTitle = new StringBuilder();
        this.getHelper().appendDatedSubtitle(subTitle, dateFilter, null);
        this.getHelper().appendSearchFilter(subTitle, "User", reportSearcher.getUserSearchFilter());
        this.getHelper().appendSearchFilter(subTitle, "Permission Groups", reportSearcher.getGroupSearchFilter());
        this.getHelper().appendSearchFilter(subTitle, "Shift", reportSearcher.getShiftSearchFilter());
        this.getHelper().appendSearchFilter(subTitle, "Trading Day", reportSearcher.getTradingDayFilter());
        this.getHelper().appendSearchFilter(subTitle, "Sales Location", reportSearcher.getSalesLocationFilter());
        builder.setSubtitle(subTitle.toString());
        try {
            if (this.isSplitFlag) {
                for (int index = 0; index < this.compiler.getColumnNamesCount(); ++index) {
                    builder.getReportBuilder().addConcatenatedReport(this.generateMainReport(index), (LayoutManager)new ClassicLayoutManager(), DATA_PATH + index, 0, 10, false);
                }
            } else {
                builder.getReportBuilder().addConcatenatedReport(this.generateMainReport(0), (LayoutManager)new ClassicLayoutManager(), DATA_PATH, 0, 10, false);
            }
            builder.getReportBuilder().addConcatenatedReport(this.generateUserAveragesReport(), (LayoutManager)new ClassicLayoutManager(), USER_AVG_PATH, 0, 10, false);
            builder.getReportBuilder().addConcatenatedReport(this.generateDayAveragesReport(), (LayoutManager)new ClassicLayoutManager(), AVG_PATH, 0, 10, false);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.warn("Cannot build sub reports", (Throwable)ex);
        }
        builder.getReportBuilder().setAllowDetailSplit(true);
        return builder;
    }

    private DynamicReport generateDayAveragesReport() {
        ReportBuilder dataSubReportBuilder = new ReportBuilder();
        for (String name : this.compiler.getTradingDaySummaryColumnNames()) {
            ColumnProperty prop = new ColumnProperty(name, String.class);
            SimpleColumn column = new SimpleColumn();
            column.setColumnProperty(prop);
            column.setName(name);
            column.setTitle(name);
            dataSubReportBuilder.getReportBuilder().addColumn((AbstractColumn)column);
        }
        return dataSubReportBuilder.buildJasperReport();
    }

    private DynamicReport generateUserAveragesReport() {
        ReportBuilder dataSubReportBuilder = new ReportBuilder();
        for (String name : this.compiler.getUserSummaryColumnNames()) {
            ColumnProperty prop = new ColumnProperty(name, String.class);
            SimpleColumn column = new SimpleColumn();
            column.setColumnProperty(prop);
            column.setName(name);
            column.setTitle(name);
            dataSubReportBuilder.getReportBuilder().addColumn((AbstractColumn)column);
        }
        return dataSubReportBuilder.buildJasperReport();
    }

    private DynamicReport generateMainReport(int index) {
        ReportBuilder dataSubReportBuilder = new ReportBuilder(new OrdermateSmallTextReportStyle());
        Style rotatedStyle = new OrderMateDefaultReportStyle().getColumnHeaderStyle();
        rotatedStyle.setStreching(Stretching.RELATIVE_TO_TALLEST_OBJECT);
        rotatedStyle.setStretchWithOverflow(false);
        rotatedStyle.setRotation(Rotation.RIGHT);
        dataSubReportBuilder.getReportBuilder().setHeaderHeight(80);
        for (String name : this.compiler.getColumnNames(index)) {
            ColumnProperty prop = new ColumnProperty(name, String.class);
            SimpleColumn column = new SimpleColumn();
            column.setColumnProperty(prop);
            column.setName(name);
            column.setTitle(name);
            column.setHeaderStyle(rotatedStyle);
            column.setStyle(new OrdermateSmallTextReportStyle().getColumnDetailStyle());
            if (name.equals("Trading Day")) {
                column.setWidth(Integer.valueOf(45));
            } else {
                column.setWidth(Integer.valueOf(30));
            }
            dataSubReportBuilder.getReportBuilder().addColumn((AbstractColumn)column);
        }
        dataSubReportBuilder.getReportBuilder().setUseFullPageWidth(false);
        return dataSubReportBuilder.getReportBuilder().build();
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.compiler.getSearcher().getTradingDayDateRangeFilter());
    }
}

