/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reconciliation;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.finance.Skim;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.entries.CreditEntry;
import ordermate.database.finance.reconciliation.entries.WebEntry;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.reconciliation.ReconciliationCompilerImp;
import ordermate.database.reports.reconciliation.ReconciliationReport;
import ordermate.database.reports.reconciliation.ReconciliationReportEntry;
import ordermate.database.reports.takings.CashdrawerTakingsReport;

public class RecReportFullImp
implements ReconciliationCompilerImp {
    private Map<String, Integer> indexMap = new HashMap<String, Integer>();
    private Set<FinanceUnit> allUnits = new HashSet<FinanceUnit>();

    @Override
    public List<ReconciliationReportEntry> makePrototypes() {
        ArrayList<ReconciliationReportEntry> prototypes = new ArrayList<ReconciliationReportEntry>();
        prototypes.add(new ReconciliationReportEntry("Cash", FinanceUnit.getUnitForName(FinanceUnit.CASH_TYPE.toString())));
        prototypes.add(new ReconciliationReportEntry("Float", null));
        prototypes.add(new ReconciliationReportEntry("Petty Cash", null));
        prototypes.add(new ReconciliationReportEntry("Skims", null));
        for (FinanceUnit unit : FinanceUnit.getElectronicUnits()) {
            prototypes.add(new ReconciliationReportEntry(unit.getLabel(), unit));
        }
        for (FinanceUnit unit : FinanceUnit.getWebUnits()) {
            prototypes.add(new ReconciliationReportEntry(unit.getLabel(), unit));
        }
        prototypes.add(new ReconciliationReportEntry("Over Ring", null));
        prototypes.add(new ReconciliationReportEntry("Cashout", null));
        prototypes.add(new ReconciliationReportEntry("Total", null));
        int count = 0;
        for (ReconciliationReportEntry nextEntry : prototypes) {
            this.allUnits.add(nextEntry.getUnit());
            this.indexMap.put(nextEntry.getLabel(), count);
            ++count;
        }
        return prototypes;
    }

    @Override
    public void addReconciliationReport(ReconciliationReport report, CashdrawerReconciliation cdRec) {
        List<ReconciliationReportEntry> entries = report.getEntries();
        ReconciliationReportEntry reportEntry = entries.get(this.indexMap.get(FinanceUnit.getDefaultUnitFor(FinanceUnit.CASH_TYPE).toString()));
        reportEntry.setActual(cdRec.getActualCashTotal());
        reportEntry.setVariance(cdRec.getTotalCashLessFloat().add(cdRec.getPettyCashTotal()).subtract(cdRec.getSystemCash()));
        entries.get(this.indexMap.get("Float")).setActual(cdRec.getFloatEntry().getValue());
        for (CreditEntry creditEntry : cdRec.getCreditEntries()) {
            reportEntry = entries.get(this.indexMap.get(creditEntry.getFinanceUnit().toString()));
            reportEntry.setActual(reportEntry.getActual().add(creditEntry.getValue()));
        }
        for (WebEntry webEntry : cdRec.getWebEntries()) {
            reportEntry = entries.get(this.indexMap.get(webEntry.getFinanceUnit().toString()));
            reportEntry.setActual(reportEntry.getActual().add(webEntry.getValue()));
        }
        entries.get(this.indexMap.get("Petty Cash")).setActual(cdRec.getPettyCashTotal());
        entries.get(this.indexMap.get("Over Ring")).setActual(cdRec.getOverringEntry().getValue());
        entries.get(this.indexMap.get("Cashout")).setActual(cdRec.getCashOutEntry().getValue());
    }

    @Override
    public void addTakingsReport(ReconciliationReport report, CashdrawerTakingsReport cdReport) {
        FinanceUnit unit = cdReport.getUnitType();
        int index = this.indexMap.get(unit.toString());
        if (SystemProperty.getInstance().isReconciliationSystemTotalIncludesTips()) {
            report.getEntries().get(index).setSystem(cdReport.getPaid().add(cdReport.getTips()));
        } else {
            report.getEntries().get(index).setSystem(cdReport.getPaid());
        }
    }

    @Override
    public void cleanup(List<ReconciliationReport> reports) {
        HashSet<FinanceUnit> toRemove = new HashSet<FinanceUnit>(this.allUnits);
        toRemove.remove(FinanceUnit.getDefaultUnitFor(FinanceUnit.CASH_TYPE));
        for (ReconciliationReport nextReport : reports) {
            if (toRemove.isEmpty()) break;
            for (ReconciliationReportEntry nextEntry : nextReport.getEntries()) {
                if (!toRemove.contains(nextEntry.getUnit()) || Price.ZERO_DOLLAR.equals(nextEntry.getActual()) && Price.ZERO_DOLLAR.equals(nextEntry.getSystem())) continue;
                toRemove.remove(nextEntry.getUnit());
            }
        }
        if (!toRemove.isEmpty()) {
            for (ReconciliationReport nextReport : reports) {
                HashSet<ReconciliationReportEntry> dropIt = new HashSet<ReconciliationReportEntry>();
                for (FinanceUnit unit : toRemove) {
                    dropIt.add(nextReport.getEntries().get(this.indexMap.get(unit.toString())));
                }
                for (ReconciliationReportEntry entry : dropIt) {
                    nextReport.getEntries().remove(entry);
                }
            }
        }
        this.indexMap = null;
    }

    @Override
    public void addSkim(ReconciliationReport report, Skim skim) {
        report.getEntries().get(this.indexMap.get("Skims")).setActual(skim.getTotal());
    }
}

