/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reconciliation;

import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.Skim;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.reconciliation.ReconciliationCompilerImp;
import ordermate.database.reports.reconciliation.ReconciliationReport;
import ordermate.database.reports.reconciliation.ReconciliationReportEntry;
import ordermate.database.reports.takings.CashdrawerTakingsReport;

public class RecReportSummaryImp
implements ReconciliationCompilerImp {
    private int FLOAT = 1;
    private int SKIMS = 3;
    private int CASH = 0;
    private int CREDIT = 4;
    private int WEB = 5;
    private int PETTY = 2;
    private int OVER = 6;
    private int CASHOUT = 7;

    @Override
    public List<ReconciliationReportEntry> makePrototypes() {
        ArrayList<ReconciliationReportEntry> prototypes = new ArrayList<ReconciliationReportEntry>();
        prototypes.add(new ReconciliationReportEntry("Cash", FinanceUnit.getUnitForName(FinanceUnit.CASH_TYPE.toString())));
        prototypes.add(new ReconciliationReportEntry("Float", null));
        prototypes.add(new ReconciliationReportEntry("Petty Cash", null));
        prototypes.add(new ReconciliationReportEntry("Skims", null));
        prototypes.add(new ReconciliationReportEntry("Credit", null));
        prototypes.add(new ReconciliationReportEntry("Web", null));
        prototypes.add(new ReconciliationReportEntry("Over Ring", null));
        prototypes.add(new ReconciliationReportEntry("Cashout", null));
        prototypes.add(new ReconciliationReportEntry("Total", null));
        return prototypes;
    }

    @Override
    public void addReconciliationReport(ReconciliationReport report, CashdrawerReconciliation rec) {
        report.getEntries().get(this.CASH).setActual(rec.getActualCashTotal());
        report.getEntries().get(this.CREDIT).setActual(rec.getCreditTotal());
        report.getEntries().get(this.WEB).setActual(rec.getWebTotal());
        report.getEntries().get(this.PETTY).setActual(rec.getPettyCashTotal());
        report.getEntries().get(this.OVER).setActual(rec.getOverringEntry().getValue());
        report.getEntries().get(this.FLOAT).setActual(rec.getFloatEntry().getValue());
        report.getEntries().get(this.CASHOUT).setActual(rec.getCashOutEntry().getValue());
        report.getEntries().get(this.CASH).setVariance(rec.getTotalCashLessFloat().add(rec.getPettyCashTotal()).subtract(rec.getSystemCash()));
    }

    @Override
    public void addTakingsReport(ReconciliationReport report, CashdrawerTakingsReport cdReport) {
        FinanceUnit unit = cdReport.getUnitType();
        int index = -1;
        if (FinanceUnit.getUnitForName("Cash").equals(unit)) {
            index = this.CASH;
        } else if (FinanceUnit.CREDIT_TYPE.toString().equals(unit.getType())) {
            index = this.CREDIT;
        } else if (FinanceUnit.DEBIT_TYPE.toString().equals(unit.getType())) {
            index = this.CREDIT;
        } else if (FinanceUnit.WEB_TYPE.toString().equals(unit.getType())) {
            index = this.WEB;
        }
        ReconciliationReportEntry entry = report.getEntries().get(index);
        if (SystemProperty.getInstance().isReconciliationSystemTotalIncludesTips()) {
            entry.setSystem(entry.getSystem().add(cdReport.getPaid().add(cdReport.getTips())));
        } else {
            entry.setSystem(entry.getSystem().add(cdReport.getPaid()));
        }
    }

    @Override
    public void addSkim(ReconciliationReport report, Skim skim) {
        report.getEntries().get(this.SKIMS).setActual(skim.getTotal());
    }

    @Override
    public void cleanup(List<ReconciliationReport> reports) {
    }
}

