/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reconciliation;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.filters.TradingDayByDateFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.reconciliation.RecReportFullImp;
import ordermate.database.reports.reconciliation.RecReportSummaryImp;
import ordermate.database.reports.reconciliation.ReconciliationCompilerImp;
import ordermate.database.reports.reconciliation.ReconciliationReport;
import ordermate.database.reports.reconciliation.ReconciliationReportEntry;
import ordermate.database.reports.reconciliation.ShiftReconciliationSearcher;
import ordermate.database.reports.takings.CashdrawerTakingsReport;
import ordermate.database.searchers.reports.takings.TakingsReportSearcher;

public class ReconciliationReportCompiler {
    public static final String OVER_RING = "Over Ring";
    public static final String PETTY_CASH = "Petty Cash";
    public static final String FLOAT = "Float";
    public static final String SKIMS = "Skims";
    public static final String CASH = "Cash";
    public static final String CASH_OUT = "Cashout";
    private final ShiftReconciliationSearcher recSearcher;
    private final ISingleValueSearchFilter<TradingDay> tradingDayFilter = new ObjectSearchFilter<TradingDay>(null);
    private final TradingDayByDateFilterAdapter tradingDayDateFilter = new TradingDayByDateFilterAdapter(this.tradingDayFilter);
    private ObjectSearchFilter<ConfigShift> shiftFilter = new ObjectSearchFilter(null);
    private final ISingleValueSearchFilter<Boolean> summaryFilter = new ObjectSearchFilter<Boolean>(null);
    private boolean summaryReport = true;
    private List<ReconciliationReportEntry> prototypes;
    private Map<String, Integer> indexMap;
    private ReconciliationCompilerImp imp;
    private ShiftReconciliation reconciliation;

    public ReconciliationReportCompiler() {
        this.recSearcher = new ShiftReconciliationSearcher();
    }

    @FilterConfig(name="Trading Day", defaultValue="DateRange", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=1)
    public ISingleValueSearchFilter<Date> getTradingDayDateFilter() {
        return this.tradingDayDateFilter;
    }

    @FilterConfig(name="Shift", defaultValue="1", dataType=ConfigShift.class, nullAllowed=false, plural=FilterConfig.Plural.Single, priority=true, sequence=2)
    public SingleValueSearchFilter<ConfigShift> getShiftFilter() {
        return this.shiftFilter;
    }

    @FilterConfig(name="Summary", dataType=Boolean.class, plural=FilterConfig.Plural.Single, nullAllowed=true)
    public ISingleValueSearchFilter<Boolean> getSummaryFilter() {
        return this.summaryFilter;
    }

    public boolean isSummary() {
        return this.summaryReport;
    }

    public void setSummary(boolean value) {
        this.summaryReport = value;
    }

    public void setReconciliation(ShiftReconciliation reconciliation) {
        if (reconciliation != null) {
            this.reconciliation = reconciliation;
            this.recSearcher.getShiftFilter().setSearchValue(reconciliation.getShift());
        }
    }

    public ShiftReconciliation getReconciliation() {
        return this.reconciliation;
    }

    public List<ReconciliationReport> compileReport() {
        Shift financeShift;
        this.tradingDayDateFilter.update();
        TradingDay tradingDay = this.tradingDayFilter.getSearchValue();
        ConfigShift configShift = (ConfigShift)this.shiftFilter.getSearchValue();
        if (tradingDay != null && configShift != null && (financeShift = Shift.getShift(tradingDay, configShift)) != null) {
            this.reconciliation = PersistenceManager.getObject(ShiftReconciliation.class, Query.select(ShiftReconciliation.class).equals(ShiftReconciliation.Properties.SHIFT, financeShift).toString());
        }
        if (this.reconciliation == null) {
            return new ArrayList<ReconciliationReport>();
        }
        this.recSearcher.getShiftFilter().setSearchValue(this.reconciliation.getShift());
        List recs = this.recSearcher.search();
        if (recs.isEmpty()) {
            return new ArrayList<ReconciliationReport>();
        }
        if (this.summaryFilter != null && this.summaryFilter.getSearchValue() != null) {
            this.summaryReport = this.summaryFilter.getSearchValue();
        }
        this.imp = this.summaryReport ? new RecReportSummaryImp() : new RecReportFullImp();
        this.createPrototypes();
        HashMap<CashDrawer, ReconciliationReport> resultsMap = new HashMap<CashDrawer, ReconciliationReport>();
        for (ShiftReconciliation rec : recs) {
            this.addToResults(rec, resultsMap);
        }
        TakingsReportSearcher txnSearcher = new TakingsReportSearcher();
        txnSearcher.onlyActive();
        txnSearcher.getShiftFilter().setSearchValue((Shift)this.recSearcher.getShiftFilter().getSearchValue());
        txnSearcher.getDateRangeFilter().clearSearch();
        List cdTxnReports = txnSearcher.search();
        for (Object report : cdTxnReports) {
            this.addToResults((CashdrawerTakingsReport)report, resultsMap);
        }
        List<Skim> skims = PersistenceManager.getObjectList(Skim.class, Query.select(Skim.class).equals(Skim.Properties.SHIFT, this.recSearcher.getShiftFilter().getSearchValue()).active(Skim.class).toString());
        for (Skim skim : skims) {
            this.imp.addSkim(this.getReport(skim.getCashDrawer(), resultsMap), skim);
        }
        ArrayList<ReconciliationReport> reports = new ArrayList<ReconciliationReport>(resultsMap.values());
        this.doTotals(reports);
        this.cleanup(reports);
        Collections.sort(reports, new Comparator<ReconciliationReport>(){

            @Override
            public int compare(ReconciliationReport o1, ReconciliationReport o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int locDif = o1.getCashDrawer().getLocation().getLabel().compareTo(o2.getCashDrawer().getLocation().getLabel());
                if (locDif == 0) {
                    locDif = o1.getCashDrawer().getLabel().compareTo(o2.getCashDrawer().getLabel());
                }
                return locDif;
            }
        });
        return reports;
    }

    private void addToResults(ShiftReconciliation rec, Map<CashDrawer, ReconciliationReport> resultsMap) {
        for (CashdrawerReconciliation cashRec : rec.getCashDrawerReconciliations()) {
            ReconciliationReport report = this.getReport(cashRec.getCashDrawer(), resultsMap);
            this.imp.addReconciliationReport(report, cashRec);
        }
    }

    private void addToResults(CashdrawerTakingsReport cdReport, Map<CashDrawer, ReconciliationReport> resultsMap) {
        ReconciliationReport report = this.getReport(cdReport.getCashDrawer(), resultsMap);
        this.imp.addTakingsReport(report, cdReport);
    }

    private ReconciliationReport getReport(CashDrawer cashdrawer, Map<CashDrawer, ReconciliationReport> resultsMap) {
        if (!resultsMap.containsKey(cashdrawer)) {
            ReconciliationReport newReport = new ReconciliationReport();
            newReport.setCashDrawer(cashdrawer);
            ArrayList<ReconciliationReportEntry> newEntries = new ArrayList<ReconciliationReportEntry>();
            for (ReconciliationReportEntry prototype : this.prototypes) {
                newEntries.add(new ReconciliationReportEntry(prototype.getLabel(), prototype.getUnit()));
            }
            newReport.setEntries(newEntries);
            resultsMap.put(cashdrawer, newReport);
        }
        return resultsMap.get(cashdrawer);
    }

    private void createPrototypes() {
        this.indexMap = new LinkedHashMap<String, Integer>();
        this.prototypes = this.imp.makePrototypes();
    }

    protected List<String> getLabels() {
        if (this.indexMap != null) {
            return new ArrayList<String>(this.indexMap.keySet());
        }
        return new ArrayList<String>();
    }

    public int getIndexFor(String label) {
        return this.indexMap.get(label);
    }

    private void cleanup(List<ReconciliationReport> reports) {
        this.imp.cleanup(reports);
        List<ReconciliationReportEntry> entries = reports.get(0).getEntries();
        this.indexMap.clear();
        for (int i = 0; i < entries.size(); ++i) {
            this.indexMap.put(entries.get(i).getLabel(), i);
        }
    }

    private void doTotals(List<ReconciliationReport> reports) {
        HashSet<String> dontAdd = new HashSet<String>();
        dontAdd.add("Total");
        dontAdd.add(FLOAT);
        dontAdd.add(OVER_RING);
        for (ReconciliationReport nextReport : reports) {
            ReconciliationReportEntry total = nextReport.getTotalEntry();
            for (ReconciliationReportEntry nextEntry : nextReport.getEntries()) {
                if (!dontAdd.contains(nextEntry.getLabel())) {
                    total.add(nextEntry);
                    continue;
                }
                if (FLOAT.equals(nextEntry.getLabel())) {
                    total.setActual(total.getActual().subtract(nextEntry.getActual()));
                    continue;
                }
                if (!OVER_RING.equals(nextEntry.getLabel())) continue;
                total.setSystem(total.getSystem().subtract(nextEntry.getActual()));
                total.setActual(total.getActual().subtract(nextEntry.getActual()));
            }
        }
    }
}

