/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reconciliation;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.ReportMakerUtility;
import ordermate.database.reports.reconciliation.ReconciliationReport;
import ordermate.database.reports.reconciliation.ReconciliationReportCompiler;
import ordermate.database.reports.reconciliation.ReconciliationReportProvider;

@MakesReport(value="Reconciliation", description="Totals of each tender type and variance, per cashdrawer for each day as entered in to the reconciliation feature", category="Audit")
public class ReconciliationReportMaker
extends ConfigurableReportMaker<ReconciliationReportCompiler, ReconciliationReportProvider> {
    @Override
    protected ReconciliationReportCompiler createSearchFilter() {
        ReconciliationReportCompiler compiler = new ReconciliationReportCompiler();
        List<ShiftReconciliation> recs = PersistenceManager.getObjectList(ShiftReconciliation.class, Query.select(ShiftReconciliation.class).equals(ShiftReconciliation.Properties.COMPLETED, Boolean.TRUE).orderBy(ShiftReconciliation.Properties.ID, true).toString());
        if (!recs.isEmpty()) {
            compiler.setReconciliation(recs.get(0));
        }
        return compiler;
    }

    @Override
    public List<Pair<String, ReportMakerUtility.TabulatedReport>> tabulateResults(ReconciliationReportProvider provider) throws BuilderException {
        List<ReconciliationReport> listReports = provider.getCompiler().compileReport();
        if (listReports == null || listReports.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> headers = new ArrayList<String>();
        ReportMakerUtility.TabulatedReportMetaData metaData = new ReportMakerUtility.TabulatedReportMetaData();
        metaData.getColumnMetaData().add(new ReportMakerUtility.ReportColumnMetaData("location", String.class.getSimpleName().toLowerCase(), null, -1, false, false));
        headers.add("location");
        metaData.getColumnMetaData().add(new ReportMakerUtility.ReportColumnMetaData("cashDrawer", String.class.getSimpleName().toLowerCase(), null, -1, false, false));
        headers.add("cashDrawer");
        for (int i = 0; i < listReports.get(0).getEntries().size(); ++i) {
            String actual = listReports.get(0).getEntries().get(i).getLabel() + " Actual";
            metaData.getColumnMetaData().add(new ReportMakerUtility.ReportColumnMetaData(actual, Number.class.getSimpleName().toLowerCase(), "$#,##0.00", -1, false, false));
            headers.add(actual);
            if (ReconciliationReportProvider.actualOnly.contains(listReports.get(0).getEntries().get(i).getLabel())) continue;
            String system = listReports.get(0).getEntries().get(i).getLabel() + " System";
            metaData.getColumnMetaData().add(new ReportMakerUtility.ReportColumnMetaData(system, Number.class.getSimpleName().toLowerCase(), "$#,##0.00", -1, false, false));
            headers.add(system);
            String variance = listReports.get(0).getEntries().get(i).getLabel() + " Variance";
            metaData.getColumnMetaData().add(new ReportMakerUtility.ReportColumnMetaData(listReports.get(0).getEntries().get(i).getLabel() + " Variance", Number.class.getSimpleName().toLowerCase(), "$#,##0.00", -1, false, false));
            headers.add(variance);
        }
        Object[][] data = new Object[listReports.size() + 1][metaData.getColumnMetaData().size()];
        data[0] = headers.toArray();
        for (int row = 0; row < listReports.size(); ++row) {
            data[row + 1][0] = listReports.get(row).getLocation();
            data[row + 1][1] = listReports.get(row).getCashDrawer();
            int offset = 2;
            for (int col = 0; col < listReports.get(row).getEntries().size(); ++col) {
                if (ReconciliationReportProvider.actualOnly.contains(listReports.get(row).getEntries().get(col).getLabel())) {
                    data[row + 1][offset] = listReports.get(row).getEntries().get(col).getActual().toString(false);
                    ++offset;
                    continue;
                }
                data[row + 1][offset] = listReports.get(row).getEntries().get(col).getActual().toString(false);
                data[row + 1][offset + 1] = listReports.get(row).getEntries().get(col).getSystem().toString(false);
                data[row + 1][offset + 2] = listReports.get(row).getEntries().get(col).getVariance().toString(false);
                offset += 3;
            }
        }
        ReportMakerUtility.TabulatedReport report = new ReportMakerUtility.TabulatedReport(data, metaData);
        return Collections.singletonList(new Pair<String, ReportMakerUtility.TabulatedReport>("Reconciliation", report));
    }

    @Override
    protected ReconciliationReportProvider createReportProvider(ReconciliationReportCompiler yourSearcher) {
        return new ReconciliationReportProvider(yourSearcher);
    }
}

