/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reconciliation;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.Rotation;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.reports.reconciliation.ReconciliationReport;
import ordermate.database.reports.reconciliation.ReconciliationReportCompiler;
import ordermate.database.reports.reconciliation.ReconciliationReportEntry;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.ListResolvingExpression;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class ReconciliationReportProvider
extends AbstractReportProvider {
    private ReconciliationReportCompiler compiler;
    public static Set<String> actualOnly = new HashSet<String>();

    public ReconciliationReportProvider(ReconciliationReportCompiler yourCompiler) {
        actualOnly.add("Cashout");
        actualOnly.add("Float");
        actualOnly.add("Petty Cash");
        actualOnly.add("Over Ring");
        actualOnly.add("Skims");
        this.compiler = yourCompiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.compiler.compileReport());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        ReportBuilder builder = this.getBuilder();
        return builder.buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(ReportBuilder.TemplateFormat.A4Landscape);
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        GroupBuilder groupBuilder = new GroupBuilder();
        this.style(builder, groupBuilder);
        builder.addInvisibleField(ReconciliationReport.Properties.REPORT);
        builder.addReportColumn(ReconciliationReport.Properties.LOCATION, "Location", "");
        builder.addReportColumn(ReconciliationReport.Properties.CASH_DRAWER, "Cashdrawer", "");
        builder.getPropertyColumn(ReconciliationReport.Properties.LOCATION).setStyle(builder.getStyles().getColumnDetailStyle());
        builder.getPropertyColumn(ReconciliationReport.Properties.CASH_DRAWER).setStyle(builder.getStyles().getColumnDetailStyle());
        PropertyColumn locationColumn = builder.getPropertyColumn(ReconciliationReport.Properties.LOCATION);
        groupBuilder.setCriteriaColumn(locationColumn);
        groupBuilder.setDefaultHeaderVariableStyle(builder.getStyles().getFooterVariableStyle());
        groupBuilder.addFooterVariable((AbstractColumn)locationColumn, new CustomExpression(){

            public String getClassName() {
                return String.class.getCanonicalName();
            }

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return "Total";
            }
        });
        builder.getPropertyColumn(ReconciliationReport.Properties.CASH_DRAWER).setWidth(Integer.valueOf(95));
        builder.getReportBuilder().setGrandTotalLegend("All Total");
        builder.getReportBuilder().setGrandTotalLegendStyle(builder.getStyles().getFooterVariableStyle());
        for (String label : this.compiler.getLabels()) {
            if (actualOnly.contains(label)) {
                this.doColumnFor(label, ReconciliationReportEntry.Properties.ACTUAL, groupBuilder, builder);
                continue;
            }
            this.doColumnFor(label, ReconciliationReportEntry.Properties.ACTUAL, groupBuilder, builder);
            AbstractColumn col = this.doColumnFor(label, ReconciliationReportEntry.Properties.SYSTEM, groupBuilder, builder);
            if ("Total".equals(label)) {
                col.setTitle("Total System");
            }
            this.doColumnFor(label, ReconciliationReportEntry.Properties.VARIANCE, groupBuilder, builder);
        }
        DJGroup group = groupBuilder.build();
        group.setName("Location");
        builder.getReportBuilder().addGroup(group);
        return builder;
    }

    private void style(ReportBuilder builder, GroupBuilder groupBuilder) {
        Font headerFont = new Font(6, "Arial", true);
        builder.getStyles().getColumnHeaderStyle().setRotation(Rotation.LEFT);
        builder.getStyles().getColumnHeaderStyle().setFont(headerFont);
        builder.getReportBuilder().setHeaderHeight(50);
        int size = this.compiler.isSummary() ? 7 : 5;
        Font font = new Font(size, "Arial", false);
        builder.getStyles().getColumnDetailStyle().setFont(font);
        Font footFont = new Font(size, "Arial", true);
        builder.getStyles().getFooterVariableStyle().setFont(footFont);
        groupBuilder.setDefaultFooterVariableStyle(builder.getStyles().getFooterVariableStyle());
        groupBuilder.setGroupLayout(GroupLayout.VALUE_IN_HEADER);
        StringBuilder SB = new StringBuilder("Reconciliation Report ");
        if (this.compiler.isSummary()) {
            SB.append("Summary - ");
        } else {
            SB.append("Detail - ");
        }
        if (this.compiler.getReconciliation() != null) {
            SB.append(this.compiler.getReconciliation().getShift());
        }
        builder.setTitle(SB.toString());
    }

    private AbstractColumn doColumnFor(String label, PropertiedObject.Property property, GroupBuilder groupBuilder, ReportBuilder builder) {
        AbstractColumn col = this.makeListColumn(label, property);
        builder.getReportBuilder().addColumn(col);
        groupBuilder.addFooterVariable(col, DJCalculation.SUM);
        col.setStyle(builder.getStyles().getColumnDetailStyle());
        builder.addFooterCalculation(col, Double.class, DJCalculation.SUM);
        return col;
    }

    private AbstractColumn makeListColumn(String label, PropertiedObject.Property listProperty) {
        int index = this.compiler.getIndexFor(label);
        ListResolvingExpression expression = new ListResolvingExpression(index, ReconciliationReport.Properties.ENTRIES, listProperty);
        ExpressionColumn column = new ExpressionColumn();
        column.setName(label + " " + listProperty.getUserVisibleLabel());
        column.setTitle(label + " " + listProperty.getUserVisibleLabel());
        column.setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        column.setColumnProperty(new ColumnProperty(listProperty.getLabel(), ReconciliationReportEntry.class));
        column.setExpression((CustomExpression)expression);
        return column;
    }

    public ReconciliationReportCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

