/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reconciliation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.misc.TradingDay;

public class ShiftReconciliationSearcher
extends PropertySearcher<ShiftReconciliation> {
    private IRangedQuerySearchFilter<Date> tradingDayFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private ObjectSearchFilter<Shift> shiftFilter;

    public ShiftReconciliationSearcher() {
        super(ShiftReconciliation.class);
        this.tradingDayFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayFilter);
        this.shiftFilter = new ObjectSearchFilter<Shift>(ShiftReconciliation.Properties.SHIFT);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.shiftFilter);
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    public ObjectSearchFilter<Shift> getShiftFilter() {
        return this.shiftFilter;
    }

    @Override
    public ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(ShiftReconciliation.class);
        if (this.tradingDayFilter.hasSearchValue()) {
            query.linkUsing(ShiftReconciliation.Properties.SHIFT).linkUsing(Shift.Properties.TRADING_DAY);
        }
        return query;
    }
}

