/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reconciliation.pettycash;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.util.Arrays;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.finance.reconciliation.entries.PettyCashEntry;
import ordermate.database.reports.reconciliation.pettycash.PettyCashSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateTimeExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class PettyCashJasperReportProvider
extends AbstractReportProvider {
    private PettyCashSearcher searcher;
    private ReportBuilder builder;

    public PettyCashJasperReportProvider(PettyCashSearcher searcher) {
        this.searcher = searcher == null ? new PettyCashSearcher() : searcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.searcher.search());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        this.builder = null;
        if (this.builder == null) {
            this.builder = new ReportBuilder();
            this.initBuilder();
        }
        this.builder.setTitle("Petty Cash Report");
        this.builder.setSubtitle(this.getSubtitle());
        return this.builder;
    }

    private void initBuilder() throws BuilderException {
        this.builder.getCustomExpressionRegister().put(Date.class, new DateTimeExpressionBuilder());
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        this.builder.addReportColumns(Arrays.asList(PettyCashEntry.Properties.SHIFT_LABEL, PettyCashEntry.Properties.CREATED, PettyCashEntry.Properties.ALLOCATION, PettyCashEntry.Properties.USER, PettyCashEntry.Properties.DESCRIPTION, PettyCashEntry.Properties.VALUE));
        this.builder.getReportBuilder().setPrintBackgroundOnOddRows(false);
        this.builder.getPropertyColumn(PettyCashEntry.Properties.SHIFT_LABEL).setTitle("Shift");
        this.builder.getPropertyColumn(PettyCashEntry.Properties.CREATED).setWidth(Integer.valueOf(30));
        this.builder.getPropertyColumn(PettyCashEntry.Properties.ALLOCATION).setWidth(Integer.valueOf(30));
        this.builder.getPropertyColumn(PettyCashEntry.Properties.USER).setWidth(Integer.valueOf(30));
        PropertyColumn valueCol = this.builder.getPropertyColumn(PettyCashEntry.Properties.VALUE);
        valueCol.setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        valueCol.setWidth(Integer.valueOf(30));
        this.builder.getPropertyColumn(PettyCashEntry.Properties.CREATED).setPattern("dd/MM/yyyy hh:mm");
        this.builder.getReportBuilder().setSubtitleHeight(20);
        ReportBuilder reportBuilder = this.builder;
        reportBuilder.getClass();
        ReportBuilder.PropertyGroupSpec shiftSpec = new ReportBuilder.PropertyGroupSpec(reportBuilder, PettyCashEntry.Properties.SHIFT_LABEL);
        Style shiftGroupStyle = new StyleBuilder(true).setFont(new Font(10, "Arial", true)).build();
        shiftSpec.setGroupedColumnStyle(shiftGroupStyle);
        DJGroup totalGroupBy = this.builder.addGroupBy(shiftSpec, Arrays.asList(new ReportBuilder.PropertyCalculation(PettyCashEntry.Properties.VALUE, DJCalculation.SUM)));
        DJGroupLabel totalLabel = new DJGroupLabel("", new Style(), LabelPosition.LEFT);
        totalGroupBy.setFooterLabel(totalLabel);
        totalGroupBy.setFitFooterHeightToContent(true);
        Style totalStyle = new StyleBuilder(true).setFont(Font.VERDANA_SMALL_BOLD).build();
        this.builder.getReportBuilder().setGrandTotalLegend("TOTAL:");
        this.builder.getReportBuilder().setGrandTotalLegendStyle(totalStyle);
        this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)valueCol, DJCalculation.SUM, totalStyle);
        totalGroupBy.setLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME);
        totalGroupBy.setStartInNewPage(Boolean.FALSE);
    }

    protected String getSubtitle() {
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getDateRangeFilter(), null);
        this.getHelper().appendSearchFilter(SB, "Shift", this.searcher.getShiftFilter());
        return SB.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

