/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reconciliation.pettycash;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import java.util.Date;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.reconciliation.entries.PettyCashEntry;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;

public class PettyCashSearcher
extends PropertySearcher<PettyCashEntry> {
    private ObjectSearchFilter<ConfigShift> shiftFilter;
    private DateRangeSearchFilter dateRangeFilter;

    public PettyCashSearcher() {
        super(PettyCashEntry.class);
        this.shiftFilter = new ObjectSearchFilter<ConfigShift>(Shift.Properties.CONFIG_SHIFT);
        this.dateRangeFilter = new DateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE);
        this.addSearchFilter(this.shiftFilter);
        this.addSearchFilter(this.dateRangeFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(PettyCashEntry.class).linkUsing(PettyCashEntry.Properties.PARENT, CashdrawerReconciliation.Properties.ID).linkUsing(CashdrawerReconciliation.Properties.PARENT, ShiftReconciliation.Properties.ID).linkUsing(ShiftReconciliation.Properties.SHIFT, Shift.Properties.ID).linkUsing(Shift.Properties.TRADING_DAY, TradingDay.Properties.ID).orderBy(PettyCashEntry.Properties.PARENT).orderBy(PettyCashEntry.Properties.PURCHASE).orderBy(PettyCashEntry.Properties.CREATED);
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, nullAllowed=false, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public DateRangeSearchFilter getDateRangeFilter() {
        return this.dateRangeFilter;
    }

    @FilterConfig(name="Shift", dataType=ConfigShift.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=2)
    public SingleValueSearchFilter<ConfigShift> getShiftFilter() {
        return this.shiftFilter;
    }
}

