/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.refunds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.reports.RefundReportSummary;
import ordermate.database.reports.RefundsReport;
import ordermate.database.searchers.reports.RefundsReportSearcher;

public class RefundReportCompiler {
    private RefundsReportSearcher searcher;
    private Map<String, RefundReportSummary> cachedResults;

    public RefundReportCompiler(RefundsReportSearcher searcher) {
        this.searcher = searcher;
        this.cachedResults = new HashMap<String, RefundReportSummary>();
    }

    public List<RefundReportSummary> getResults() {
        this.cachedResults.clear();
        List searchResults = this.searcher.search();
        for (RefundsReport refund : searchResults) {
            String user = refund.getUserName();
            if (this.cachedResults.get(user) == null) {
                this.cachedResults.put(user, new RefundReportSummary(user));
            }
            this.cachedResults.get(user).addRefund(refund.getQuantity().intValue(), refund.getTotal());
        }
        ArrayList<RefundReportSummary> toReturn = new ArrayList<RefundReportSummary>();
        toReturn.addAll(this.cachedResults.values());
        return toReturn;
    }

    public RefundsReportSearcher getSearcher() {
        return this.searcher;
    }
}

