/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.refunds;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.Arrays;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.RefundReportSummary;
import ordermate.database.reports.RefundsReport;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.refunds.RefundReportCompiler;
import ordermate.database.searchers.reports.RefundsReportSearcher;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class RefundReportProvider
extends AbstractReportProvider {
    private RefundReportCompiler compiler;
    private SearcherDataSourceProvider searcherDataSourceProvider;
    private static final String DATA = "DATA";

    public RefundReportProvider(RefundsReportSearcher searcher) {
        this.searcherDataSourceProvider = new SearcherDataSourceProvider<RefundsReportSearcher>(searcher);
        this.compiler = new RefundReportCompiler(searcher);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.searcherDataSourceProvider.getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.addParam(DATA, new JRBeanCollectionDataSource(this.compiler.getResults()));
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        this.addParam(DATA, new JRBeanCollectionDataSource(this.compiler.getResults()));
        builder.setTitle("Refunds Performed");
        RefundsReportSearcher reportSearcher = (RefundsReportSearcher)this.searcherDataSourceProvider.getSearch();
        IRangedQuerySearchFilter<Date> dateFilter = reportSearcher.getTradingDayDateRangeFilter();
        IRangedQuerySearchFilter<Date> dateAdapter = reportSearcher.getTradingDayDateRangeAdapter();
        PeriodReportAdapter period = reportSearcher.getPeriod();
        StringBuilder subTitle = new StringBuilder();
        if (period == null) {
            subTitle.append(TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(dateAdapter));
        } else {
            subTitle.append(period.formatTradingDayRangeForDisplay((Date)dateFilter.getStart(), (Date)dateFilter.getEnd(), (Date)dateAdapter.getEnd()));
        }
        String timeString = reportSearcher.getTimeFilter().getDisplayableTime();
        if (!timeString.isEmpty()) {
            this.getHelper().appendSubTitleAndValue(subTitle, "Day Part", timeString);
        }
        this.getHelper().appendSearchFilter(subTitle, "User", reportSearcher.getUserSearchFilter());
        this.getHelper().appendSearchFilter(subTitle, "Sales Location", reportSearcher.getSalesLocationFilter());
        builder.setSubtitle(subTitle.toString());
        builder.addReportColumns(Arrays.asList(RefundsReport.Properties.USER_NAME, RefundsReport.Properties.CREATION_TIME, RefundsReport.Properties.SALES_ITEM, RefundsReport.Properties.ITEM_SIZE, RefundsReport.Properties.PORTION, RefundsReport.Properties.QUANTITY, RefundsReport.Properties.TOTAL), "User", "Time", "Item", "Size", "Portion", "Qty", "\\" + Internationalization.getLiteralFor("DOLLAR_SIGN") + " Refunded");
        ReportBuilder.PropertyCalculation sumQty = new ReportBuilder.PropertyCalculation(RefundsReport.Properties.QUANTITY, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumSales = new ReportBuilder.PropertyCalculation(RefundsReport.Properties.TOTAL, DJCalculation.SUM);
        DJGroup group = builder.addGroupBy(RefundsReport.Properties.USER_NAME, Arrays.asList(sumQty, sumSales));
        DJGroupLabel footerLabel = new DJGroupLabel("Total: ", builder.getStyles().getFooterVariableStyle(), LabelPosition.LEFT);
        group.setLayout(GroupLayout.DEFAULT_WITH_HEADER);
        group.setFooterLabel(footerLabel);
        Style groupedColumnStyle = builder.getStyles().getGroupedDetailStyle();
        PropertyColumn groupCol = builder.getPropertyColumn(RefundsReport.Properties.USER_NAME);
        groupCol.setHeaderStyle(groupedColumnStyle);
        group.setReprintHeaderOnEachPage(Boolean.TRUE);
        group.setAllowHeaederSplit(false);
        group.setAllowFooterSplit(false);
        group.setHeaderHeight(Integer.valueOf(15));
        try {
            builder.getReportBuilder().addConcatenatedReport(this.generateSummaryReport(), (LayoutManager)new ClassicLayoutManager(), DATA, 0, 10, false);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.warn("Cannot build sub reports", (Throwable)ex);
        }
        builder.getReportBuilder().setAllowDetailSplit(true);
        builder.getPropertyColumn(RefundsReport.Properties.QUANTITY).setPattern("0");
        builder.getPropertyColumn(RefundsReport.Properties.TOTAL).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        return builder;
    }

    private DynamicReport generateSummaryReport() throws ColumnBuilderException {
        ReportBuilder dataSubReportBuilder = new ReportBuilder();
        dataSubReportBuilder.addReportColumn(RefundReportSummary.Properties.USER, "User", null);
        dataSubReportBuilder.addReportColumn(RefundReportSummary.Properties.AVG_REFUNDED, "Average Refunded", null);
        dataSubReportBuilder.addReportColumn(RefundReportSummary.Properties.TOTAL_QTY, "Total Quantity", null);
        dataSubReportBuilder.addReportColumn(RefundReportSummary.Properties.TOTAL_REFUNDED, "Total Refunded", null);
        dataSubReportBuilder.getReportBuilder().setAllowDetailSplit(true);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(RefundReportSummary.Properties.TOTAL_QTY), DJCalculation.SUM, null);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(RefundReportSummary.Properties.TOTAL_REFUNDED), DJCalculation.SUM, null);
        dataSubReportBuilder.getReportBuilder().setGrandTotalLegend("Total Values");
        return dataSubReportBuilder.buildJasperReport();
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.compiler.getSearcher().getTradingDayDateRangeFilter()) + "\n Negative values indicate a refund reversal";
    }
}

