/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reservations;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.reports.reservations.ReservationsSearcher;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.sales.reservation.Reservation;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class ReservationReportProvider
extends AbstractReportProvider {
    private final SearcherDataSourceProvider searcherDataSourceProvider;

    public ReservationReportProvider(ReservationsSearcher theSearcher) {
        this.searcherDataSourceProvider = new SearcherDataSourceProvider<ReservationsSearcher>(theSearcher);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle(){

            @Override
            protected Style constructFooterVariableStyle() {
                Style style = super.constructFooterVariableStyle();
                style.setFont(Font.ARIAL_SMALL);
                return style;
            }

            @Override
            protected Style constructGroupedDetailStyle() {
                Style style = super.constructGroupedDetailStyle();
                style.setFont(Font.ARIAL_BIG_BOLD);
                return style;
            }
        });
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Daily Reservations Report");
        builder.setSubtitle(this.generateSubtitle());
        builder.getCustomExpressionRegister().put(Date.class, new DateExpressionBuilder(new SimpleDateFormat("MMM d, yyyy")));
        builder.addReportColumns(Arrays.asList(Reservation.Properties.SECTION, Reservation.Properties.CUSTOMER_NAME, Reservation.Properties.NUM_PATRONS, Reservation.Properties.TABLES, Reservation.Properties.DATE, Reservation.Properties.TIME_STRING, Reservation.Properties.CONFIRMED_STRING, Reservation.Properties.COMMENTS), "Section", "Name", Internationalization.getLiteralFor("COVERS"), Internationalization.getLiteralFor("TABLE"), "Date", "Time", "Confirmed?", "Note");
        ReportBuilder.PropertyCalculation sumPatrons = new ReportBuilder.PropertyCalculation(Reservation.Properties.NUM_PATRONS, DJCalculation.SUM);
        DJGroup group = builder.addGroupBy(Reservation.Properties.SECTION, Arrays.asList(sumPatrons));
        DJGroupLabel footerLabel = new DJGroupLabel("Section Pax: ", builder.getStyles().getFooterVariableStyle(), LabelPosition.LEFT);
        group.setFooterLabel(footerLabel);
        group.setLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME);
        group.setHeaderHeight(Integer.valueOf(20));
        group.setFitHeaderHeightToContent(true);
        group.setFooterVariablesHeight(Integer.valueOf(20));
        group.setFitFooterHeightToContent(true);
        PropertyColumn groupCol = builder.getPropertyColumn(Reservation.Properties.SECTION);
        this.hideColumnName(groupCol);
        builder.addFooterCalculation(sumPatrons);
        builder.getReportBuilder().setGrandTotalLegend("Total Pax: ");
        builder.getReportBuilder().setGrandTotalLegendStyle(this.cloneGrandTotalStyle(builder.getStyles().getColumnDetailStyle()));
        builder.getPropertyColumn(Reservation.Properties.DATE).setPattern("dd/MM/yy");
        return builder;
    }

    private Style cloneGrandTotalStyle(Style returnStyle) {
        Style topAlign = returnStyle;
        try {
            topAlign = (Style)returnStyle.clone();
            topAlign.setVerticalAlign(VerticalAlign.TOP);
            topAlign.setBorderBottom(Border.NO_BORDER);
            topAlign.setFont(Font.ARIAL_MEDIUM);
        }
        catch (CloneNotSupportedException e) {
            OrderMateLog.LOG.warn("Unable to clone report style");
        }
        return topAlign;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.searcherDataSourceProvider.getDataSource();
    }

    protected String generateSubtitle() {
        TimeSearchFilter timeFilter;
        String time;
        Date end;
        ReservationsSearcher reportSearcher = (ReservationsSearcher)this.searcherDataSourceProvider.getSearch();
        SimpleDateFormat df = new SimpleDateFormat("EEEEEEEEEEEEEEEEEE dd/MM/yyyy");
        IRangedQuerySearchFilter<Date> dateFilter = reportSearcher.getDateSearchFilter();
        Date start = (Date)dateFilter.getStart();
        if (start.after(end = (Date)dateFilter.getEnd())) {
            start = (Date)dateFilter.getEnd();
            end = (Date)dateFilter.getStart();
        }
        StringBuilder SB = new StringBuilder(df.format(start));
        if (DateTimeUtils.clearTimePart(end).after(DateTimeUtils.clearTimePart(start))) {
            SB.append(" - " + df.format(end));
        }
        if (!StringUtils.isEmpty(time = (timeFilter = reportSearcher.getTimeFilter()).getDisplayableTime())) {
            this.getHelper().appendSubTitleAndValue(SB, "Day Part", time);
        }
        return SB.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

