/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.reservations;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.sales.reservation.Reservation;

public class ReservationsSearcher
extends PropertySearcher<Reservation> {
    IRangedQuerySearchFilter<Date> dateFilter;
    TimeSearchFilter timeFilter;

    public ReservationsSearcher() {
        super(Reservation.class);
        this.dateFilter = new OptimisedDateRangeSearchFilter(Reservation.Properties.DATE, SQLDateType.DATE);
        this.timeFilter = new TimeSearchFilter(Reservation.Properties.TIME);
        this.addSearchFilter(this.dateFilter);
        this.addSearchFilter(this.timeFilter);
    }

    @Override
    public ObjectQuery getBaseQuery() {
        return Query.select(Reservation.class).active(Reservation.class).orderBy(Reservation.Properties.SECTION).orderBy(Reservation.Properties.TIME);
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getDateSearchFilter() {
        return this.dateFilter;
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=2)
    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }
}

