/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.byarea;

import au.com.ordermate.persistence.ArrayObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.MathsUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.queries.stock.StockAreaQueries;
import ordermate.database.queries.stock.StockInvoiceQueries;
import ordermate.database.queries.stock.StockUsageQueries;
import ordermate.database.reports.sales.byarea.SalesByAreaSearcher;
import ordermate.database.stock.StockArea;

public class SalesByAreaCompiler {
    public static final int NUM_COLS = 7;
    public static final int AREA_COLUMN = 0;
    public static final int CATEGORY_COLUMN = 1;
    public static final int SALES_COLUMN = 2;
    public static final int SALES_EX_COLUMN = 3;
    public static final int COGS_COLUMN = 4;
    public static final int GP_COLUMN = 5;
    public static final int GP_PERCENT_COLUMN = 6;
    private static final Double ZERO = 0.0;
    public static final String TOTAL_AREA = "TOTALS";
    private static final int INVOICE_FEES_CATEGORY_ID = -1;
    private static final int ADJUSTMENTS_CATEGORY_ID = -2;
    private static final int WASTAGE_CATEGORY_ID = -3;
    private SalesByAreaSearcher searcher;
    private Hashtable<RowID, Number> categoryIDsForSales;
    private Hashtable<RowID, Number> categoryIDsForSalesEx;
    private Hashtable<RowID, Number> categoryIDsForCOGS;
    private Hashtable<RowID, Number> categoryIDsForGP;
    private Hashtable<RowID, Number> categoryIDsForGPPercent;
    private Hashtable<Long, double[]> totals;

    public SalesByAreaCompiler(SalesByAreaSearcher yourSearcher) {
        this.searcher = yourSearcher;
        this.categoryIDsForCOGS = new Hashtable();
        this.categoryIDsForSales = new Hashtable();
        this.categoryIDsForSalesEx = new Hashtable();
        this.categoryIDsForGP = new Hashtable();
        this.categoryIDsForGPPercent = new Hashtable();
        this.totals = new Hashtable();
    }

    public TableModel compile() {
        this.clearAll();
        Date start = (Date)this.searcher.getDateRangeFilter().getStart();
        Date end = (Date)this.searcher.getDateRangeFilter().getEnd();
        Object[][] adjustmentsAndWastages = PersistenceManager.getPersistenceDelegate().executeQuery(StockUsageQueries.Reports.GetUsageValue.QUERY, new Object[]{start, end});
        Object[][] invoiceFees = PersistenceManager.getPersistenceDelegate().executeQuery(StockInvoiceQueries.Reports.GetInvoiceExtraCosts.QUERY_PER_AREA, new Object[]{start, end});
        Object[][] discountResults = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT 1 as 'ID', SUM((sales_component.item_discount_total + sales_component.account_discount_total) * sales_item_quantity.quantity) * -1 AS Discount_Amount FROM sales_item_quantity INNER JOIN sales_item ON sales_item.ID = sales_item_quantity.FK_sales_item INNER JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID INNER JOIN sales_component ON sales_component.FK_sales_item = sales_item.ID WHERE sales_item_quantity.creation_time BETWEEN ? AND ? ", new Object[]{start, end});
        Object[][] surchargeResults = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT SUM((sales_component.item_surcharge_total + sales_component.account_surcharge_total) * sales_item_quantity.quantity) AS Surcharge_Amount FROM sales_item_quantity INNER JOIN sales_item ON sales_item.ID = sales_item_quantity.FK_sales_item INNER JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID INNER JOIN sales_component ON sales_component.FK_sales_item = sales_item.ID WHERE sales_item_quantity.creation_time BETWEEN ? AND ? ", new Object[]{start, end});
        List<InventoryCategory> categories = InventoryCategory.getAllCategoriesIncDeleted();
        List<StockArea> areas = StockArea.getStockAreas();
        int numAreas = areas.size();
        int numCategories = categories.size();
        ArrayList<String> areaNames = new ArrayList<String>(numAreas + 1);
        for (int i = 0; i < numAreas; ++i) {
            areaNames.add(areas.get(i).getLabel());
        }
        areaNames.add(TOTAL_AREA);
        ++numAreas;
        for (InventoryCategory cat : categories) {
            this.totals.put(cat.getID(), new double[7]);
        }
        this.totals.put(new Long(-1L), new double[7]);
        this.totals.put(new Long(-2L), new double[7]);
        this.totals.put(new Long(-3L), new double[7]);
        List<ArrayObject> rawResults = this.searcher.search();
        DefaultTableModel actualModel = new DefaultTableModel();
        for (int c = 0; c < StockAreaQueries.displayColumns.length; ++c) {
            actualModel.addColumn(StockAreaQueries.displayColumns[c]);
        }
        int numRows = rawResults.size();
        for (int r = 0; r < numRows; ++r) {
            ArrayObject row = rawResults.get(r);
            Long categoryID = (Long)row.getArray()[7];
            String area = (String)row.getArray()[StockAreaQueries.columnsToDisplay[0]];
            Number cogs = this.safelyGetNumber((Number)row.getArray()[StockAreaQueries.columnsToDisplay[4]]);
            Number sales = this.safelyGetNumber((Number)row.getArray()[StockAreaQueries.columnsToDisplay[2]]);
            Number salesEx = this.safelyGetNumber((Number)row.getArray()[StockAreaQueries.columnsToDisplay[3]]);
            Number gp = this.safelyGetNumber((Number)row.getArray()[StockAreaQueries.columnsToDisplay[5]]);
            Number gpPercent = this.safelyGetNumber((Number)row.getArray()[StockAreaQueries.columnsToDisplay[6]]);
            double[] existingTotals = this.totals.get(categoryID);
            if (existingTotals != null) {
                existingTotals[4] = existingTotals[4] + cogs.doubleValue();
                existingTotals[2] = existingTotals[2] + sales.doubleValue();
                existingTotals[3] = existingTotals[3] + salesEx.doubleValue();
                existingTotals[5] = existingTotals[5] + gp.doubleValue();
                existingTotals[6] = 0.0;
                if (!MathsUtils.approxEquals(0.0, existingTotals[3])) {
                    existingTotals[6] = existingTotals[5] / existingTotals[3];
                }
            }
            RowID rowID = new RowID(area, categoryID);
            this.categoryIDsForCOGS.put(rowID, cogs);
            this.categoryIDsForSales.put(rowID, sales);
            this.categoryIDsForSalesEx.put(rowID, salesEx);
            this.categoryIDsForGP.put(rowID, gp);
            this.categoryIDsForGPPercent.put(rowID, gpPercent);
        }
        for (InventoryCategory cat : categories) {
            double[] existingTotals = this.totals.get(cat.getID());
            RowID rowID = new RowID(TOTAL_AREA, cat.intID());
            this.categoryIDsForCOGS.put(rowID, existingTotals[4]);
            this.categoryIDsForSales.put(rowID, existingTotals[2]);
            this.categoryIDsForSalesEx.put(rowID, existingTotals[3]);
            this.categoryIDsForGP.put(rowID, existingTotals[5]);
            this.categoryIDsForGPPercent.put(rowID, existingTotals[6]);
        }
        for (int a = 0; a < numAreas; ++a) {
            String areaName = (String)areaNames.get(a);
            for (int c = 0; c < numCategories; ++c) {
                InventoryCategory category = categories.get(c);
                RowID rowID = new RowID(areaName, category.intID());
                Object[] row = new Object[7];
                row[0] = areaName;
                row[1] = category.isDeleted() ? category.getLabel() + " [DELETED]" : category.getLabel();
                row[4] = this.categoryIDsForCOGS.get(rowID);
                row[2] = this.categoryIDsForSales.get(rowID);
                row[3] = this.categoryIDsForSalesEx.get(rowID);
                row[5] = this.categoryIDsForGP.get(rowID);
                row[6] = this.categoryIDsForGPPercent.get(rowID);
                if (String.valueOf(row[6]).indexOf(69) != -1) {
                    row[6] = 0.0;
                }
                for (int i = 2; i <= 6; ++i) {
                    if (row[i] != null) continue;
                    row[i] = ZERO;
                }
                if (((String)row[1]).contains("[DELETED]") && row[2].equals(ZERO)) continue;
                actualModel.addRow(row);
            }
            double invoiceFee = this.getTotalInvoiceFeeForArea(invoiceFees, areaName);
            double adjustmentTotal = this.getTotalAdjustmentsForArea(adjustmentsAndWastages, areaName);
            double wastageTotal = this.getTotalWastagesForArea(adjustmentsAndWastages, areaName);
            Object[] invoiceFeeRow = this.createArtificialCostRow(areaName, "(Invoice Fees)", invoiceFee);
            actualModel.addRow(invoiceFeeRow);
            Object[] adjustmentRow = this.createArtificialCostRow(areaName, "(Adjustments)", adjustmentTotal);
            actualModel.addRow(adjustmentRow);
            Object[] wastageRow = this.createArtificialCostRow(areaName, "(Wastages)", wastageTotal);
            actualModel.addRow(wastageRow);
            if (!areaName.equals(TOTAL_AREA)) continue;
            double discountTotal = 0.0;
            if (discountResults[0][1] != null) {
                discountTotal = -Math.abs(((Number)discountResults[0][1]).doubleValue());
            }
            Object[] percentDiscountRow = this.createArtificialSalesRow(areaName, "(Discounts)", discountTotal);
            actualModel.addRow(percentDiscountRow);
            double surchargeTotal = 0.0;
            if (surchargeResults[0][0] != null) {
                surchargeTotal = Math.abs(((Number)surchargeResults[0][0]).doubleValue());
            }
            Object[] percentSurchargeRow = this.createArtificialSalesRow(areaName, "(Surcharges)", surchargeTotal);
            actualModel.addRow(percentSurchargeRow);
        }
        return actualModel;
    }

    private Number safelyGetNumber(Number number) {
        if (number == null) {
            return ZERO;
        }
        return number;
    }

    private void clearAll() {
        this.categoryIDsForCOGS.clear();
        this.categoryIDsForSales.clear();
        this.categoryIDsForSalesEx.clear();
        this.categoryIDsForGP.clear();
        this.categoryIDsForGPPercent.clear();
        this.totals.clear();
    }

    private double getTotalInvoiceFeeForArea(Object[][] invoiceFeeResults, String areaName) {
        double invoiceFee = 0.0;
        boolean doTotal = areaName.equals(TOTAL_AREA);
        for (int i = 0; i < invoiceFeeResults.length; ++i) {
            String areaHere = (String)invoiceFeeResults[i][3];
            Double feeObj = (Double)invoiceFeeResults[i][1];
            if (doTotal) {
                invoiceFee += feeObj.doubleValue();
                continue;
            }
            if (!areaHere.equals(areaName)) continue;
            invoiceFee = feeObj;
            break;
        }
        return invoiceFee;
    }

    private double getTotalAdjustmentsForArea(Object[][] adjustmentResults, String areaName) {
        double total = 0.0;
        boolean doTotal = areaName.equals(TOTAL_AREA);
        for (int i = 0; i < adjustmentResults.length; ++i) {
            String usageState = (String)adjustmentResults[i][1];
            String areaHere = (String)adjustmentResults[i][0];
            Double totalObj = (Double)adjustmentResults[i][2];
            if (!usageState.equals("ADJUST")) continue;
            if (doTotal) {
                total += totalObj.doubleValue();
                continue;
            }
            if (!areaHere.equals(areaName)) continue;
            total = totalObj;
            break;
        }
        return total;
    }

    private double getTotalWastagesForArea(Object[][] wastageResults, String areaName) {
        double total = 0.0;
        boolean doTotal = areaName.equals(TOTAL_AREA);
        for (int i = 0; i < wastageResults.length; ++i) {
            String usageState = (String)wastageResults[i][1];
            String areaHere = (String)wastageResults[i][0];
            Double totalObj = (Double)wastageResults[i][3];
            if (!usageState.equals("WASTED")) continue;
            if (doTotal) {
                total += totalObj.doubleValue();
                continue;
            }
            if (!areaHere.equals(areaName)) continue;
            total = totalObj;
            break;
        }
        return total;
    }

    private Object[] createArtificialCostRow(String areaName, String categoryName, double price) {
        Double nought = ZERO;
        Object[] row = new Object[7];
        row[0] = areaName;
        row[1] = categoryName;
        row[4] = price;
        row[2] = nought;
        row[3] = nought;
        row[5] = nought;
        row[6] = nought;
        return row;
    }

    private Object[] createArtificialSalesRow(String areaName, String categoryName, double price) {
        Double nought = ZERO;
        Object[] row = new Object[7];
        row[0] = areaName;
        row[1] = categoryName;
        row[4] = nought;
        row[2] = price;
        row[3] = price;
        row[5] = nought;
        row[6] = nought;
        return row;
    }

    private static class RowID {
        final long CAT_ID;
        final String AREA_NAME;

        RowID(String areaName, long catID) {
            this.AREA_NAME = areaName;
            this.CAT_ID = catID;
        }

        public boolean equals(Object o) {
            if (o instanceof RowID) {
                RowID r = (RowID)o;
                return this.CAT_ID == r.CAT_ID && this.AREA_NAME.equals(r.AREA_NAME);
            }
            return false;
        }

        public int hashCode() {
            return (int)((long)this.AREA_NAME.hashCode() + this.CAT_ID);
        }
    }
}

