/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.byarea;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.persistence.ArrayObject;
import java.text.Format;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.queries.stock.StockAreaQueries;
import ordermate.database.reports.sales.byarea.SalesByAreaCompiler;
import ordermate.database.reports.sales.byarea.SalesByAreaSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.PriceExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class SalesByAreaReportProvider
extends AbstractReportProvider {
    private SalesByAreaSearcher searcher;
    private final NumberFormat percentageFormatter;

    public SalesByAreaReportProvider(SalesByAreaSearcher searcher) {
        this.searcher = searcher;
        this.percentageFormatter = NumberFormat.getPercentInstance();
        this.percentageFormatter.setMinimumFractionDigits(1);
        this.percentageFormatter.setMaximumFractionDigits(2);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        List<ArrayObject> values = this.searcher.search();
        Object[][] data = new Object[values.size()][StockAreaQueries.columnsToDisplay.length];
        for (int i = 0; i < values.size(); ++i) {
            Object[] thing = values.get(i).getArray();
            for (int j = 0; j < StockAreaQueries.columnsToDisplay.length; ++j) {
                data[i][j] = thing[StockAreaQueries.columnsToDisplay[j]];
                if (data[i][j] == null) {
                    data[i][j] = 0.0;
                }
                if (j != 6) continue;
                data[i][j] = (Double)data[i][j] / 100.0;
            }
        }
        TableModel model = new SalesByAreaCompiler(this.searcher).compile();
        JRTableModelDataSource source = new JRTableModelDataSource(model);
        return source;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        OrderMateMinimalistStyle style = new OrderMateMinimalistStyle();
        ReportBuilder builder = new ReportBuilder(style);
        builder.setTitle("Sales by Area");
        builder.setSubtitle("from " + this.searcher.getDateRangeFilter().getStart() + " to " + this.searcher.getDateRangeFilter().getEnd());
        for (int i = 0; i < StockAreaQueries.displayColumns.length; ++i) {
            ColumnProperty prop;
            SimpleColumn column;
            if (i > 1 && i < 6) {
                column = new SimpleColumn();
                prop = new ColumnProperty(StockAreaQueries.displayColumns[i], Double.class);
                column.setTextFormatter((Format)NumberFormat.getCurrencyInstance());
                column.setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            } else if (i == 6) {
                column = new SimpleColumn();
                prop = new ColumnProperty(StockAreaQueries.displayColumns[i], Double.class);
                column.setTextFormatter((Format)this.percentageFormatter);
            } else {
                column = new SimpleColumn();
                prop = new ColumnProperty(StockAreaQueries.displayColumns[i], String.class);
            }
            column.setName(StockAreaQueries.displayColumns[i]);
            column.setTitle(StockAreaQueries.displayColumns[i]);
            column.setColumnProperty(prop);
            builder.getReportBuilder().addColumn((AbstractColumn)column);
        }
        GroupBuilder group = new GroupBuilder();
        group.setCriteriaColumn((PropertyColumn)builder.getReportBuilder().getColumn(0));
        group.addFooterVariable(builder.getReportBuilder().getColumn(2), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
        group.addFooterVariable(builder.getReportBuilder().getColumn(3), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
        group.addFooterVariable(builder.getReportBuilder().getColumn(4), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
        group.addFooterVariable(builder.getReportBuilder().getColumn(5), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
        group.addFooterVariable(builder.getReportBuilder().getColumn(6), new CustomExpression(){

            public String getClassName() {
                return String.class.getName();
            }

            public Object evaluate(Map fields, Map variables, Map parameters) {
                double percentage = (Double)fields.get(StockAreaQueries.displayColumns[5]) / (Double)fields.get(StockAreaQueries.displayColumns[3]);
                if (Double.isInfinite(percentage) || Double.isNaN(percentage)) {
                    return "";
                }
                return SalesByAreaReportProvider.this.percentageFormatter.format(percentage);
            }
        }, style.getFooterVariableStyle());
        builder.getReportBuilder().addGroup(group.build());
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

