/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.byarea;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.ObjectQuerySQLAdapter;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ordermate.database.queries.stock.StockAreaQueries;
import ordermate.database.searchers.ArrayObjectSearcher;

public class SalesByAreaSearcher
extends ArrayObjectSearcher {
    private DateRangeSearchFilter dateRangeFilter = new DateRangeSearchFilter(null, SQLDateType.TIMESTAMP);

    public SalesByAreaSearcher() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        this.dateRangeFilter.setStart(cal.getTime());
        cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        this.dateRangeFilter.setEnd(cal.getTime());
    }

    public String getSelectQuery() {
        return StockAreaQueries.Reports.GetSalesAndCOGS.QUERY_PER_AREA_CATEGORY;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        String query = this.getSelectQuery();
        Timestamp sqlFrom = new Timestamp(((Date)this.dateRangeFilter.getStart()).getTime());
        Timestamp sqlTo = new Timestamp(((Date)this.dateRangeFilter.getEnd()).getTime());
        query = query.replaceFirst("\\?", "'" + sqlFrom.toString() + "'");
        query = query.replaceFirst("\\?", "'" + sqlTo.toString() + "'");
        return new ObjectQuerySQLAdapter(query);
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList(StockAreaQueries.displayColumns);
    }

    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.TIMESTAMP, nullAllowed=false, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public DateRangeSearchFilter getDateRangeFilter() {
        return this.dateRangeFilter;
    }
}

