/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.bydaypart;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.UniquePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.sales.bydaypart.SalesByDayPartReport;
import ordermate.database.searchers.reports.sales.bydaypart.AbstractSalesByDayPartSearcher;

public class SalesByDayPartReportCompiler {
    private final AbstractSalesByDayPartSearcher searcher;
    private final Map<UniquePair<String, String>, Pair<SalesQuantity, Price>> dayPartSalesMap;
    private final Map<String, List<Object>> tableData;
    private final Map<String, Pair<SalesQuantity, Price>> totalsMap;

    public SalesByDayPartReportCompiler(AbstractSalesByDayPartSearcher searcher) {
        this.searcher = searcher;
        this.dayPartSalesMap = new LinkedHashMap<UniquePair<String, String>, Pair<SalesQuantity, Price>>();
        this.tableData = new LinkedHashMap<String, List<Object>>();
        this.totalsMap = new HashMap<String, Pair<SalesQuantity, Price>>();
    }

    public AbstractSalesByDayPartSearcher getSearcher() {
        return this.searcher;
    }

    public List<String> getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(this.searcher.getSalesObjectName());
        List<DayPart> dayParts = DayPart.getAllDayParts(true);
        for (DayPart dayPart : dayParts) {
            columns.add(dayPart.getLabel() + " Qty");
            columns.add(dayPart.getLabel() + " Sales");
        }
        columns.add("Total Qty");
        columns.add("Total Sales");
        return columns;
    }

    public List<List<Object>> compile() {
        List<Object> row;
        this.dayPartSalesMap.clear();
        this.totalsMap.clear();
        this.tableData.clear();
        List<SalesByDayPartReport> reports = this.searcher.search();
        this.primeMaps(reports);
        this.calculateTotals(reports);
        if (reports != null && reports.size() > 0) {
            for (SalesByDayPartReport salesByDayPartReport : reports) {
                Pair<SalesQuantity, Price> values;
                String salesObj;
                String dayPart;
                if (!salesByDayPartReport.getDayPart().equals("All Day")) {
                    dayPart = salesByDayPartReport.getDayPart().substring(2);
                    salesObj = salesByDayPartReport.getSalesObject();
                    values = this.getPairFor(dayPart, salesObj);
                    values.setKey(values.getKey().add(salesByDayPartReport.getSalesCount()));
                    values.setVal(values.getVal().add(salesByDayPartReport.getSalesValue()));
                    continue;
                }
                dayPart = salesByDayPartReport.getDayPart();
                salesObj = salesByDayPartReport.getSalesObject();
                values = this.getPairFor(dayPart, salesObj);
                values.setKey(values.getKey().add(salesByDayPartReport.getSalesCount()));
                values.setVal(values.getVal().add(salesByDayPartReport.getSalesValue()));
            }
        }
        for (UniquePair uniquePair : this.dayPartSalesMap.keySet()) {
            row = this.tableData.get(uniquePair.getVal());
            row.add(this.dayPartSalesMap.get(uniquePair).getKey().toString());
            row.add(this.dayPartSalesMap.get(uniquePair).getVal().toString());
        }
        for (String string : this.tableData.keySet()) {
            row = this.tableData.get(string);
            row.add(this.totalsMap.get(string).getKey().toString());
            row.add(this.totalsMap.get(string).getVal().toString());
        }
        ArrayList<List<Object>> toReturn = new ArrayList<List<Object>>(this.tableData.values());
        this.dayPartSalesMap.clear();
        this.totalsMap.clear();
        this.tableData.clear();
        return toReturn;
    }

    private Pair<SalesQuantity, Price> getPairFor(String dayPart, String salesObj) {
        return this.dayPartSalesMap.get(new UniquePair<String, String>(dayPart, salesObj));
    }

    private void primeMaps(List<SalesByDayPartReport> reports) {
        List<DayPart> dayParts = DayPart.getAllDayParts(true);
        if (dayParts == null || dayParts.size() == 0) {
            for (SalesByDayPartReport report : reports) {
                String salesObj = report.getSalesObject();
                this.dayPartSalesMap.put(new UniquePair<String, String>("All Day", salesObj), new Pair<SalesQuantity, Price>(SalesQuantity.ZERO, new Price(0.0, 0.0)));
                this.tableData.put(salesObj, new ArrayList());
                this.tableData.get(salesObj).add(salesObj);
            }
        } else {
            for (SalesByDayPartReport report : reports) {
                String salesObj = report.getSalesObject();
                for (DayPart dayPart : dayParts) {
                    this.dayPartSalesMap.put(new UniquePair<String, String>(dayPart.getLabel(), salesObj), new Pair<SalesQuantity, Price>(SalesQuantity.ZERO, new Price(0.0, 0.0)));
                }
                this.tableData.put(salesObj, new ArrayList());
                this.tableData.get(salesObj).add(salesObj);
            }
        }
    }

    private void calculateTotals(List<SalesByDayPartReport> reports) {
        if (reports == null || reports.size() == 0) {
            return;
        }
        for (SalesByDayPartReport report : reports) {
            String salesObj = report.getSalesObject();
            if (!this.totalsMap.containsKey(salesObj)) {
                this.totalsMap.put(salesObj, new Pair<SalesQuantity, Price>(report.getSalesCount(), report.getSalesValue()));
                continue;
            }
            SalesQuantity currentCount = this.totalsMap.get(salesObj).getKey();
            Price currentTotal = this.totalsMap.get(salesObj).getVal();
            this.totalsMap.get(salesObj).setKey(currentCount.add(report.getSalesCount()));
            this.totalsMap.get(salesObj).setVal(currentTotal.add(report.getSalesValue()));
        }
    }
}

