/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.bydaypart.provider;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.sales.bydaypart.provider.SalesByDayPartReportProvider;
import ordermate.database.searchers.reports.sales.bydaypart.AbstractSalesByDayPartSearcher;
import ordermate.database.searchers.reports.sales.bydaypart.ComboSalesByDayPartSearcher;
import ordermate.database.searchers.reports.sales.bydaypart.ItemSalesByDayPartSearcher;
import ordermate.database.searchers.reports.sales.bydaypart.MenuSectionSalesByDayPartSearcher;
import ordermate.database.searchers.reports.sales.bydaypart.OptionSalesByDayPartSearcher;
import ordermate.database.searchers.reports.sales.bydaypart.PlusSalesByDayPartSearcher;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class ComprehensiveSalesByDayPartReportProvider
extends AbstractReportProvider {
    private static final String REPORT_TITLE = "Comprehensive Sales by Day Part Report";
    private final List<SalesByDayPartReportProvider> providers = new ArrayList<SalesByDayPartReportProvider>();
    private AbstractSalesByDayPartSearcher searcher;

    public ComprehensiveSalesByDayPartReportProvider(AbstractSalesByDayPartSearcher searcher) {
        this.providers.add(this.createProvider(new MenuSectionSalesByDayPartSearcher()));
        this.providers.add(this.createProvider(new ItemSalesByDayPartSearcher()));
        this.providers.add(this.createProvider(new ComboSalesByDayPartSearcher()));
        this.providers.add(this.createProvider(new OptionSalesByDayPartSearcher()));
        this.providers.add(this.createProvider(new PlusSalesByDayPartSearcher()));
        this.searcher = searcher;
    }

    public ComprehensiveSalesByDayPartReportProvider() {
        this.providers.add(this.createProvider(new MenuSectionSalesByDayPartSearcher()));
        this.providers.add(this.createProvider(new ItemSalesByDayPartSearcher()));
        this.providers.add(this.createProvider(new ComboSalesByDayPartSearcher()));
        this.providers.add(this.createProvider(new OptionSalesByDayPartSearcher()));
        this.providers.add(this.createProvider(new PlusSalesByDayPartSearcher()));
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanArrayDataSource(new Object[]{"NoData"});
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateMinimalistStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle(REPORT_TITLE);
        builder.setSubtitle(this.getSubtitle());
        for (SalesByDayPartReportProvider provider : this.providers) {
            String dataSourceKey = provider.getCompiler().getSearcher().getSalesObjectName();
            if (this.searcher != null) {
                provider.getCompiler().getSearcher().getDateRangeFilter().setStart((Date)this.searcher.getDateRangeFilter().getStart());
                provider.getCompiler().getSearcher().getDateRangeFilter().setEnd((Date)this.searcher.getDateRangeFilter().getEnd());
                provider.getCompiler().getSearcher().getSalesLocationFilter().setSearchValue(this.searcher.getSalesLocationFilter().getSearchValue());
            }
            this.getParameters().put(dataSourceKey, provider.getDataSource());
            this.validateThreadState();
            this.addReport(builder, provider, dataSourceKey);
        }
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }

    public List<SalesByDayPartReportProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    private void addReport(ReportBuilder builder, SalesByDayPartReportProvider provider, String dataSourceKey) {
        try {
            builder.getReportBuilder().addConcatenatedReport(provider.getReport(), (LayoutManager)new ClassicLayoutManager(), dataSourceKey, 0, 10);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Could not add a sub-report for the " + dataSourceKey + " Sales by Day Part Report Provider!", (Throwable)e);
        }
    }

    private String getSubtitle() {
        AbstractSalesByDayPartSearcher searcher = this.providers.get(0).getCompiler().getSearcher();
        StringBuilder sb = new StringBuilder();
        String tax = searcher.isIncludeTax() ? "Inc Tax" : "Ex Tax";
        String startDate = DateTimeUtils.getDateTimeFormat().format(this.getSafeDate((Date)searcher.getTradingDayFilterAdapter().getStart()));
        String endDate = DateTimeUtils.getDateTimeFormat().format(this.getSafeDate((Date)searcher.getTradingDayFilterAdapter().getEnd()));
        sb.append("[").append(tax).append("] From ").append(startDate).append(" to ").append(endDate);
        this.getHelper().appendSearchFilter(sb, "Sales Location", searcher.getSalesLocationFilter());
        return sb.toString();
    }

    private Date getSafeDate(Date date) {
        if (date == null) {
            return new Date();
        }
        return date;
    }

    private SalesByDayPartReportProvider createProvider(AbstractSalesByDayPartSearcher searcher) {
        return new SalesByDayPartReportProvider(searcher);
    }
}

