/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.bydaypart.provider;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.sales.bydaypart.SalesByDayPartReportCompiler;
import ordermate.database.reports.sales.bydaypart.SalesByDayPartReportHelper;
import ordermate.database.searchers.reports.sales.bydaypart.AbstractSalesByDayPartSearcher;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class SalesByDayPartReportProvider
extends AbstractReportProvider {
    private static final String TITLE = " Sales";
    private final SalesByDayPartReportCompiler compiler;

    public SalesByDayPartReportProvider(AbstractSalesByDayPartSearcher searcher) {
        this.compiler = new SalesByDayPartReportCompiler(searcher);
    }

    public SalesByDayPartReportCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        TableModel tableModel = SalesByDayPartReportHelper.INSTANCE.createTableModel(this.getCompiler());
        return new JRTableModelDataSource(tableModel);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateMinimalistStyle());
        builder.setTitle(this.compiler.getSearcher().getSalesObjectName() + TITLE);
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.compiler.getSearcher().getDateRangeFilter(), null);
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.compiler.getSearcher().getSalesLocationFilter());
        if (!this.compiler.getSearcher().isIncludeTax()) {
            SB.append("Ex Tax");
        }
        builder.setSubtitle(SB.toString());
        builder.getReportBuilder().setWhenNoData("-", Style.createBlankStyle((String)"DashForZero"));
        List<String> columnNames = this.compiler.getColumns();
        for (String columnName : columnNames) {
            SimpleColumn col = JasperReportHelper.makeColumn(columnName, String.class);
            builder.getReportBuilder().addColumn((AbstractColumn)col);
        }
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

