/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import ordermate.database.inventory.combos.InventoryCombo;

public class ComboSoldReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<InventoryCombo> inventoryCombo;
    private String comboName;
    private String comboType;
    private String itemName;
    private String itemSize;
    private BigDecimal portion;
    private BigDecimal itemsSold;
    private Price unitPrice;
    private Price menuPrice;
    private Price cogs;

    public ComboSoldReport() {
        this.inventoryCombo = this.createReference(ComboSoldReport.Properties.INVENTORY_COMBO);
    }

    public String getComboName() {
        return this.comboName;
    }

    public void setComboName(String comboName) {
        this.comboName = comboName;
    }

    public String getComboType() {
        return this.comboType;
    }

    public void setComboType(String comboType) {
        this.comboType = comboType;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(String itemSize) {
        this.itemSize = itemSize;
    }

    public BigDecimal getItemsSold() {
        return this.itemsSold;
    }

    public void setItemsSold(BigDecimal itemsSold) {
        this.itemsSold = itemsSold;
    }

    public Price getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Price unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Price getMenuPrice() {
        return this.menuPrice;
    }

    public void setMenuPrice(Price value) {
        this.menuPrice = value;
    }

    public Price getDiscount() {
        return this.menuPrice.subtract(this.unitPrice);
    }

    public Long getInventoryComboId() {
        return this.inventoryCombo.getID();
    }

    public InventoryCombo getInventoryCombo() {
        return this.inventoryCombo.get();
    }

    public void setInventoryCombo(InventoryCombo combo) {
        this.inventoryCombo.set(combo);
    }

    public BigDecimal getPortion() {
        return this.portion;
    }

    public void setPortion(BigDecimal portion) {
        this.portion = portion;
    }

    public Price getCogs() {
        return this.cogs;
    }

    public void setCogs(Price value) {
        this.cogs = value;
    }

    public Double getCogsPercentage() {
        if (this.cogs != null && this.unitPrice != null) {
            if (this.unitPrice.isZero()) {
                return 1.0;
            }
            return this.cogs.divide(this.unitPrice).doubleValue();
        }
        return 0.0;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<InventoryCombo> INVENTORY_COMBO;
        public PropertiedObject.Property<String> COMBO_NAME;
        public PropertiedObject.Property<String> COMBO_TYPE;
        public PropertiedObject.Property<String> ITEM_NAME;
        public PropertiedObject.Property<String> ITEM_SIZE;
        public PropertiedObject.Property<BigDecimal> PORTION;
        public PropertiedObject.Property<Double> ITEMS_SOLD;
        public PropertiedObject.Property<Price> UNIT_PRICE;
        public PropertiedObject.Property<Price> MENU_PRICE;
        public PersistentObject.DerivedProperty<Price> DISCOUNT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ComboSoldReport.class), "discount");
        public PropertiedObject.Property<Price> COGS;
        public PersistentObject.DerivedProperty<Double> COGS_PERCENTAGE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ComboSoldReport.class), "cogsPercentage");
    }
}

