/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.inventory.InventoryOptionGroup;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@AccessType(value="property")
public class OptionSoldReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Long optionId;
    private String extraLabel;
    private String optionGroupName;
    private String optionGroupSize;
    private String optionName;
    private BigDecimal quantity;
    private Price salesValue;
    private Reference<InventoryOptionGroup> optionGroup;

    public OptionSoldReport() {
        this.optionGroup = this.createReference(OptionSoldReport.Properties.OPTION_GROUP);
    }

    @Transient
    public Long getOptionId() {
        return this.optionId;
    }

    public void setOptionId(Long value) {
        this.optionId = value;
    }

    @Column(name="option_group_name")
    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    @Column(name="option_group_size")
    public String getOptionGroupSize() {
        return this.optionGroupSize;
    }

    public void setOptionGroupSize(String optionGroupSize) {
        this.optionGroupSize = optionGroupSize;
    }

    @Column(name="option_name")
    public String getOptionName() {
        return this.optionName;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    @Column(name="quantity")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setSalesValue(Price salesValue) {
        this.salesValue = salesValue;
    }

    @Column(name="sales_value")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getSalesValue() {
        return this.salesValue;
    }

    public void setOptionGroup(InventoryOptionGroup invOptionGroup) {
        this.optionGroup.set(invOptionGroup);
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_option_group", referencedColumnName="ID")
    public InventoryOptionGroup getOptionGroup() {
        return this.optionGroup.get();
    }

    @Transient
    public Price getAveragePrice() {
        if (this.getQuantity() == null || this.getQuantity().compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return this.getSalesValue().divide(this.getQuantity());
    }

    @Transient
    public String getOptionGroupAndSize() {
        return this.getOptionGroupName() + " (" + this.getOptionGroupSize() + ")";
    }

    @Override
    public String toString() {
        return "OptionSoldReport [optionGroupName=" + this.optionGroupName + ", optionGroupSize=" + this.optionGroupSize + ", optionName=" + this.optionName + "]";
    }

    @Column(name="extra_label")
    public String getExtraLabel() {
        return this.extraLabel;
    }

    public void setExtraLabel(String value) {
        this.extraLabel = value;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Long> OPTION_ID;
        public PropertiedObject.Property<String> OPTION_GROUP_NAME;
        public PropertiedObject.Property<String> OPTION_GROUP_SIZE;
        public PropertiedObject.Property<String> OPTION_NAME;
        public PropertiedObject.Property QUANTITY;
        public PropertiedObject.Property SALES_VALUE;
        public PropertiedObject.Property<InventoryOptionGroup> OPTION_GROUP;
        public PersistentObject.DerivedProperty<Price> AVERAGE_PRICE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)OptionSoldReport.class), "averagePrice");
        public PersistentObject.DerivedProperty<String> OPTION_GROUP_AND_SIZE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)OptionSoldReport.class), "optionGroupAndSize");
        public PersistentObject.DerivedProperty<String> EXTRA_LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)OptionSoldReport.class), "extraLabel");
    }
}

