/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import ordermate.database.inventory.InventoryAddGroup;

public class PlusesSoldReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Long plusId;
    private String plusGroupName;
    private String plusGroupSize;
    private String plusName;
    private Double quantity;
    private Price totalPrice;
    private Reference<InventoryAddGroup> addGroup;

    public PlusesSoldReport() {
        this.addGroup = this.createReference(PlusesSoldReport.Properties.ADD_GROUP);
    }

    public Long getPlusId() {
        return this.plusId;
    }

    public void setPlusId(Long value) {
        this.plusId = value;
    }

    public String getPlusGroupName() {
        return this.plusGroupName;
    }

    public void setPlusGroupName(String plusGroupName) {
        this.plusGroupName = plusGroupName;
    }

    public String getPlusGroupSize() {
        return this.plusGroupSize;
    }

    public void setPlusGroupSize(String plusGroupSize) {
        this.plusGroupSize = plusGroupSize;
    }

    public String getPlusName() {
        return this.plusName;
    }

    public void setPlusName(String plusName) {
        this.plusName = plusName;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public Price getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(Price totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Reference<InventoryAddGroup> getAddGroup() {
        return this.addGroup;
    }

    public void setAddGroup(Reference<InventoryAddGroup> addGroup) {
        this.addGroup = addGroup;
    }

    public Price getAveragePrice() {
        if (this.getQuantity() == null || this.getQuantity().equals(0.0)) {
            return null;
        }
        return this.getTotalPrice().divide(this.getQuantity());
    }

    public String getAddGroupAndSize() {
        return this.getPlusGroupName() + " (" + this.getPlusGroupSize() + ")";
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Long> PLUS_ID;
        public PropertiedObject.Property<String> PLUS_GROUP_NAME;
        public PropertiedObject.Property<String> PLUS_GROUP_SIZE;
        public PropertiedObject.Property<String> PLUS_NAME;
        public PropertiedObject.Property QUANTITY;
        public PropertiedObject.Property<Price> TOTAL_PRICE;
        public PropertiedObject.Property<InventoryAddGroup> ADD_GROUP;
        public PersistentObject.DerivedProperty<Price> AVERAGE_PRICE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PlusesSoldReport.class), "averagePrice");
        public PersistentObject.DerivedProperty<String> ADD_GROUP_AND_SIZE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PlusesSoldReport.class), "addGroupAndSize");
    }
}

