/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general.itemsold;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.builders.SubReportBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.reports.ReportLoader;
import au.com.ordermate.util.Price;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.reports.CategorySalesReport;
import ordermate.database.reports.SalesTotalsHolder;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReport;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.printing.PrintUtilities;

public class ItemSoldHelper {
    private static final String SALES_TOTALS_FILE = "ItemSoldReportTotals.jrxml";
    static final String SALES_TOTALS_PARAMS = "salesTotalSource";
    private static final String CATEGORY_TOTALS_PARAMS = "categoryTotalsSource";

    public static final ReportBuilder createCategoryTotalsReport(boolean includeChart) throws BuilderException {
        ReportBuilder catBuilder = new ReportBuilder();
        catBuilder.setTitle("Category Totals:");
        catBuilder.addReportColumns(Arrays.asList(CategorySalesReport.Properties.INVENTORY_CATEGORY_NAME, CategorySalesReport.Properties.QUANTITY_SOLD, CategorySalesReport.Properties.SALES_VALUE_RAW, CategorySalesReport.Properties.PERC_OF_SALES), "Category", "# Sales", "Value", "% of Sales");
        catBuilder.getPropertyColumn(CategorySalesReport.Properties.PERC_OF_SALES).setTextFormatter((Format)new DecimalFormat("#0.0%"));
        catBuilder.getPropertyColumn(CategorySalesReport.Properties.SALES_VALUE_RAW).setPattern(Internationalization.getLiteralFor("PRICE_PATTERN"));
        catBuilder.getReportBuilder().setPrintColumnNames(true);
        catBuilder.addInvisibleField(CategorySalesReport.Properties.SALES_VALUE_RAW);
        if (includeChart) {
            catBuilder.createPieChart((byte)2, catBuilder.getPropertyColumn(CategorySalesReport.Properties.INVENTORY_CATEGORY_NAME), new AbstractColumn[]{catBuilder.getPropertyColumn(CategorySalesReport.Properties.SALES_VALUE_RAW)});
        }
        return catBuilder;
    }

    public static final ReportBuilder addCategoryTotalsReport(ReportBuilder builder, boolean includeChart) throws BuilderException {
        ReportBuilder catBuilder = ItemSoldHelper.createCategoryTotalsReport(includeChart);
        SubReportBuilder subBuilder = new SubReportBuilder();
        subBuilder.setDynamicReport(catBuilder.buildJasperReport(), (LayoutManager)new ClassicLayoutManager());
        subBuilder.setDataSource(0, 0, CATEGORY_TOTALS_PARAMS);
        subBuilder.setUserParentReportParameterMap(true);
        subBuilder.setStartInNewPage(true);
        try {
            builder.getReportBuilder().addConcatenatedReport(subBuilder.build());
        }
        catch (DJBuilderException ex) {
            throw new BuilderException((Throwable)ex);
        }
        return catBuilder;
    }

    public static final void addSalesTotalReport(ReportBuilder builder) throws BuilderException {
        try {
            SubReportBuilder subBuilder = new SubReportBuilder().setReport(ReportLoader.loadReport(PrintUtilities.class, SALES_TOTALS_FILE)).setUserParentReportParameterMap(true);
            subBuilder.setDataSource(0, 0, SALES_TOTALS_PARAMS);
            builder.getReportBuilder().addConcatenatedReport(subBuilder.build());
        }
        catch (JRException ex) {
            OrderMate.LOG.warn("Could not load subreport, totals will not be displayed", (Throwable)ex);
        }
        catch (DJBuilderException ex) {
            throw new BuilderException((Throwable)ex);
        }
    }

    public static void addCategoryTotalsParams(Map<String, Object> map, List<ItemSoldReport> reports) {
        map.put(CATEGORY_TOTALS_PARAMS, ItemSoldHelper.getCategoryTotals(reports));
    }

    public static final void addSalesTotalsParams(Map<String, Object> map, List<ItemSoldReport> reports) {
        map.put(SALES_TOTALS_PARAMS, ItemSoldHelper.getSalesTotalParams(reports));
    }

    private static final List<SalesTotalsHolder> getSalesTotalParams(List<ItemSoldReport> reports) {
        SalesTotalsHolder holder = new SalesTotalsHolder(ItemSoldHelper.getDiscountTotal(reports), ItemSoldHelper.getSurchargeTotal(reports), ItemSoldHelper.getGrandTotal(reports), ItemSoldHelper.getTotalTax(reports));
        return Collections.singletonList(holder);
    }

    private static final List<CategorySalesReport> getCategoryTotals(List<ItemSoldReport> reports) {
        HashMap<String, CategorySalesReport> map = new HashMap<String, CategorySalesReport>();
        double totalSold = 0.0;
        for (ItemSoldReport itemSoldReport : reports) {
            InventoryCategory category = itemSoldReport.getInventoryCategory();
            if (category == null) continue;
            CategorySalesReport catReport = (CategorySalesReport)map.get(itemSoldReport.getInventoryCategory().getLabel());
            if (catReport == null) {
                catReport = new CategorySalesReport(itemSoldReport.getInventoryCategory().getLabel());
                map.put(itemSoldReport.getInventoryCategory().getLabel(), catReport);
            }
            catReport.addItemSoldReport(itemSoldReport);
            totalSold += itemSoldReport.getSalesValueRaw().doubleValue();
        }
        Price total = new Price(totalSold, 1.0E-5);
        for (CategorySalesReport categorySalesReport : map.values()) {
            categorySalesReport.setTotalSales(total);
        }
        ArrayList<CategorySalesReport> arrayList = new ArrayList<CategorySalesReport>(map.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    private static final Price getGrandTotal(List<ItemSoldReport> reports) {
        Price total = new Price(0.0, 1.0E-5);
        for (ItemSoldReport report : reports) {
            total = total.add(report.getSalesValue());
        }
        return total;
    }

    private static final Price getTotalTax(List<ItemSoldReport> reports) {
        Price total = new Price(0.0, 1.0E-5);
        for (ItemSoldReport report : reports) {
            total = total.add(report.getUnitTax().multiply(report.getQuantitySold().doubleValue()));
        }
        return total;
    }

    private static final Price getDiscountTotal(List<ItemSoldReport> reports) {
        Price total = new Price(0.0, 1.0E-5);
        for (ItemSoldReport report : reports) {
            if (report.getDiscountTotal() == null) continue;
            total = total.add(report.getDiscountTotal());
        }
        return total;
    }

    private static final Price getSurchargeTotal(List<ItemSoldReport> reports) {
        Price total = new Price(0.0, 1.0E-5);
        for (ItemSoldReport report : reports) {
            if (report.getSurchargeTotal() == null) continue;
            total = total.add(report.getSurchargeTotal());
        }
        return total;
    }
}

