/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general.itemsold;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.TradingDay;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="report_item_sold")
@AccessType(value="property")
public class ItemSoldReport
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<InventoryItem> item;
    private Reference<InventoryGroup> inventoryGroup;
    private Reference<InventoryCategory> inventoryCategory;
    private Reference<InventoryItemSize> size;
    private Reference<InventoryItemPortion> portion;
    private Reference<TradingDay> tradingDay;
    private Long unitId;
    private String inventoryItemName;
    private String inventoryGroupName;
    private String inventoryPortionName;
    private String inventorySizeName;
    private String categoryName;
    private BigDecimal quantitySold;
    private Price totalPrice;
    private Price totalTax;
    private Price accountDiscountTotal;
    private Price itemDiscountTotal;
    private Price accountSurchargeTotal;
    private Price itemSurchargeTotal;
    private boolean loyaltyRedeemed;
    private Price totalCogs;
    private Double salesPerc;
    private transient Price unitTax;
    private transient Price unitPrice;
    private Date reportDate;
    private String businessLocation;

    public ItemSoldReport() {
        this.item = this.createReference(ItemSoldReport.Properties.ITEM);
        this.inventoryGroup = this.createReference(ItemSoldReport.Properties.INVENTORY_GROUP);
        this.inventoryCategory = this.createReference(ItemSoldReport.Properties.INVENTORY_CATEGORY);
        this.size = this.createReference(ItemSoldReport.Properties.SIZE);
        this.portion = this.createReference(ItemSoldReport.Properties.PORTION);
        this.tradingDay = this.createReference(ItemSoldReport.Properties.TRADING_DAY);
        this.inventoryItemName = "";
        this.inventoryGroupName = "";
        this.inventoryPortionName = "";
        this.inventorySizeName = "";
        this.categoryName = "";
        this.quantitySold = BigDecimal.ZERO;
        this.totalPrice = Price.ZERO_NO_ROUND;
        this.totalTax = Price.ZERO_NO_ROUND;
        this.accountDiscountTotal = Price.ZERO_NO_ROUND;
        this.itemDiscountTotal = Price.ZERO_NO_ROUND;
        this.accountSurchargeTotal = Price.ZERO_NO_ROUND;
        this.itemSurchargeTotal = Price.ZERO_NO_ROUND;
        this.businessLocation = "";
    }

    @Override
    public void init() {
        this.getInventoryGroup();
        super.init();
    }

    @Transient
    public Long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(Long value) {
        this.unitId = value;
    }

    @Transient
    public String getBusinessLocation() {
        return BusinessInfo.getInstance().getLocation();
    }

    public void setBusinessLocation(String businessLocation) {
        this.businessLocation = businessLocation;
    }

    @Column(name="total_price")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getTotalPrice() {
        return this.totalPrice;
    }

    void setTotalPrice(Price value) {
        this.totalPrice = value;
    }

    @Column(name="total_tax")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getTotalTax() {
        return this.totalTax;
    }

    protected void setTotalTax(Price value) {
        this.totalTax = value;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_inventory_group")
    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_inventory_category")
    public InventoryCategory getInventoryCategory() {
        return this.inventoryCategory.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_inventory_size")
    public InventoryItemSize getSize() {
        return this.size.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_inventory_portion")
    public InventoryItemPortion getPortion() {
        return this.portion.get();
    }

    @Transient
    public Boolean getLoyaltyRedeemedBoolean() {
        return this.loyaltyRedeemed;
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_item")
    public InventoryItem getItem() {
        return this.item.get();
    }

    protected void setItem(InventoryItem value) {
        this.item.set(value);
    }

    @Column(name="inventory_item_name")
    public String getInventoryItemName() {
        return this.inventoryItemName;
    }

    @Column(name="item_discount_total")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getItemDiscountTotal() {
        return this.itemDiscountTotal;
    }

    @Column(name="item_surcharge_total")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getItemSurchargeTotal() {
        return this.itemSurchargeTotal;
    }

    @Column(name="account_discount_total")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getAccountDiscountTotal() {
        return this.accountDiscountTotal;
    }

    @Column(name="account_surcharge_total")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getAccountSurchargeTotal() {
        return this.accountSurchargeTotal;
    }

    @Transient
    public Price getDiscountTotal() {
        return this.getItemDiscountTotal().add(this.getAccountDiscountTotal());
    }

    @Transient
    public Price getSurchargeTotal() {
        return this.getItemSurchargeTotal().add(this.getAccountSurchargeTotal());
    }

    @Transient
    public Price getUnitTax() {
        if (this.unitTax == null) {
            this.unitTax = this.getQuantitySold().doubleValue() == 0.0 ? Price.ZERO_NO_ROUND : this.totalTax.divide(this.getQuantitySold());
        }
        return this.unitTax;
    }

    @Transient
    public String getMenuSection() {
        return this.getInventoryGroup() != null ? this.getInventoryGroup().getLabel() : this.inventoryGroupName;
    }

    @Column(name="loyalty_redeemed")
    public boolean getLoyaltyRedeemed() {
        return this.loyaltyRedeemed;
    }

    @Transient
    public Price getSalesValue() {
        if (this.loyaltyRedeemed) {
            return Price.ZERO_NO_ROUND;
        }
        return this.totalPrice;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    public void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    protected void setInventoryCategory(InventoryCategory cat) {
        this.inventoryCategory.set(cat);
    }

    protected void setInventoryGroup(InventoryGroup group) {
        this.inventoryGroup.set(group);
    }

    protected void setInventoryItemName(String name) {
        this.inventoryItemName = name;
    }

    protected void setItemDiscountTotal(Price amount) {
        this.itemDiscountTotal = amount;
    }

    protected void setItemSurchargeTotal(Price amount) {
        this.itemSurchargeTotal = amount;
    }

    protected void setAccountDiscountTotal(Price amount) {
        this.accountDiscountTotal = amount;
    }

    protected void setAccountSurchargeTotal(Price amount) {
        this.accountSurchargeTotal = amount;
    }

    protected void setPortion(InventoryItemPortion inventoryPortion) {
        this.portion.set(inventoryPortion);
    }

    protected void setSize(InventoryItemSize invSize) {
        this.size.set(invSize);
    }

    protected void setLoyaltyRedeemed(boolean redeemed) {
        this.loyaltyRedeemed = redeemed;
    }

    @Column(name="quantity_sold")
    public BigDecimal getQuantitySold() {
        return this.quantitySold;
    }

    @Transient
    public Price getUnitPrice() {
        if (this.unitPrice == null) {
            this.unitPrice = this.getQuantitySold().doubleValue() == 0.0 ? Price.ZERO_NO_ROUND : this.totalPrice.divide(this.getQuantitySold());
        }
        return this.unitPrice;
    }

    @Transient
    public Double getSalesValueRaw() {
        return new Double(this.getSalesValue().doubleValue());
    }

    public void setQuantitySold(BigDecimal qty) {
        this.quantitySold = qty;
    }

    @Column(name="report_date")
    @Temporal(value=TemporalType.DATE)
    public Date getReportDate() {
        return this.reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public void addReport(ItemSoldReport report) {
        this.setTradingDay(null);
        this.quantitySold = this.quantitySold.add(report.getQuantitySold());
        this.totalPrice = this.totalPrice.add(report.getTotalPrice());
        this.totalTax = this.totalTax.add(report.getTotalTax());
        this.accountDiscountTotal = this.accountDiscountTotal.add(report.getAccountDiscountTotal());
        this.itemDiscountTotal = this.itemDiscountTotal.add(report.getItemDiscountTotal());
        this.accountSurchargeTotal = this.accountSurchargeTotal.add(report.getAccountSurchargeTotal());
        this.itemSurchargeTotal = this.itemSurchargeTotal.add(report.getItemSurchargeTotal());
        this.unitTax = null;
        this.unitPrice = null;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (!this.tradingDay.isNull()) {
            PersistenceManager.save(this);
        }
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    protected synchronized void setID(Long newID) {
        if (newID != null && newID == 0L) {
            super.setID(null);
        } else {
            super.setID(newID);
        }
    }

    @Column(name="inventory_group_name")
    public String getInventoryGroupName() {
        return this.inventoryGroupName;
    }

    protected void setInventoryGroupName(String inventoryGroupName) {
        this.inventoryGroupName = inventoryGroupName;
    }

    @Column(name="inventory_portion_name")
    public String getInventoryPortionName() {
        return this.inventoryPortionName;
    }

    protected void setInventoryPortionName(String inventoryPortionName) {
        this.inventoryPortionName = inventoryPortionName;
    }

    @Column(name="inventory_size_name")
    public String getInventorySizeName() {
        return this.inventorySizeName;
    }

    protected void setInventorySizeName(String inventorySizeName) {
        this.inventorySizeName = inventorySizeName;
    }

    @Column(name="total_cogs")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getTotalCogs() {
        return this.totalCogs;
    }

    protected void setTotalCogs(Price totalCogs) {
        this.totalCogs = totalCogs;
    }

    @Transient
    public Price getUnitCogs() {
        if (this.totalCogs != null && this.getQuantitySold().doubleValue() != 0.0) {
            return this.totalCogs.divide(this.getQuantitySold());
        }
        return Price.ZERO_NO_ROUND;
    }

    @Transient
    public Double getTotalCogsPercentage() {
        if (this.totalCogs != null && this.totalPrice != null) {
            if (this.loyaltyRedeemed || this.totalPrice.isZero()) {
                return 1.0;
            }
            return this.totalCogs.divide(this.totalPrice).doubleValue();
        }
        return 0.0;
    }

    @Transient
    public String getCategoryName() {
        return this.categoryName;
    }

    protected void setCategoryName(String value) {
        this.categoryName = value;
    }

    public void setTotalSales(double value) {
        this.salesPerc = this.getSalesValue().doubleValue() / value;
    }

    @Transient
    public Double getSalesPerc() {
        return this.salesPerc;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<InventoryCategory> INVENTORY_CATEGORY;
        public PropertiedObject.Property<String> INVENTORY_ITEM_NAME;
        public PropertiedObject.Property<InventoryItem> ITEM;
        public PropertiedObject.Property<InventoryItemSize> SIZE;
        public PropertiedObject.Property<InventoryItemPortion> PORTION;
        public PropertiedObject.Property<Long> UNIT_ID;
        public PropertiedObject.Property LOYALTY_REDEEMED;
        public PropertiedObject.Property<Price> TOTAL_TAX;
        public PropertiedObject.Property<Price> TOTAL_PRICE;
        public PropertiedObject.Property<Price> QUANTITY_SOLD;
        public PropertiedObject.Property<Price> ITEM_DISCOUNT_TOTAL;
        public PropertiedObject.Property<Price> ITEM_SURCHARGE_TOTAL;
        public PropertiedObject.Property<Price> ACCOUNT_DISCOUNT_TOTAL;
        public PropertiedObject.Property<Price> ACCOUNT_SURCHARGE_TOTAL;
        public PropertiedObject.Property<Price> TOTAL_COGS;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Date> REPORT_DATE;
        public PropertiedObject.Property<String> INVENTORY_GROUP_NAME;
        public PropertiedObject.Property<String> INVENTORY_SIZE_NAME;
        public PropertiedObject.Property<String> INVENTORY_PORTION_NAME;
        public PropertiedObject.Property<String> CATEGORY_NAME;
        public PersistentObject.DerivedProperty<Price> UNIT_PRICE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "unitPrice");
        public PersistentObject.DerivedProperty<Price> UNIT_TAX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "unitTax");
        public PersistentObject.DerivedProperty MENU_SECTION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "menuSection");
        public PersistentObject.DerivedProperty<Price> DISCOUNT_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "discountTotal");
        public PersistentObject.DerivedProperty<Price> SURCHARGE_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "surchargeTotal");
        public PersistentObject.DerivedProperty<Double> TOTAL_COGS_PERCENTAGE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "totalCogsPercentage");
        public PersistentObject.DerivedProperty<Price> UNIT_COGS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "unitCogs");
        public PersistentObject.DerivedProperty LOYALTY_REDEEMED_BOOLEAN = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "loyaltyRedeemedBoolean");
        public PersistentObject.DerivedProperty<Price> SALES_VALUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "salesValue");
        public PersistentObject.DerivedProperty<Double> SALES_VALUE_RAW = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "salesValueRaw");
        public PersistentObject.DerivedProperty<Double> SALES_PERC = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "salesPerc");
        public PersistentObject.DerivedProperty<String> BUSINESS_LOCATION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldReport.class), "businessLocation");
    }
}

