/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general.itemsold;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.reports.ReportConfigureColumnMetaData;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Pair;
import java.math.BigDecimal;
import java.util.List;
import ordermate.database.reports.SalesTotalsHolder;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.ReportMakerUtility;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReportProvider;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportCompiler;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportSearcher;

@MakesReport(value="Item Sold", description="Itemised total of quantity sold, unit price, total sales value % of sales, COGS and COGS % for each item", category="Sales & Takings", subcategory="Sales", columnMetaData={@ReportConfigureColumnMetaData(name="Unit ID", grouped=0), @ReportConfigureColumnMetaData(name="Menu Section", grouped=0), @ReportConfigureColumnMetaData(name="Menu Item", locked=true), @ReportConfigureColumnMetaData(name="Size", grouped=1), @ReportConfigureColumnMetaData(name="Portion", grouped=2), @ReportConfigureColumnMetaData(name="Category", grouped=3), @ReportConfigureColumnMetaData(name="Sales", totaled=true), @ReportConfigureColumnMetaData(name="Quantity", totaled=true), @ReportConfigureColumnMetaData(name="# Sales", totaled=true), @ReportConfigureColumnMetaData(name="Value", totaled=true)})
public class ItemSoldReportMaker
extends ConfigurableReportMaker<ItemSoldReportSearcher, ItemSoldReportProvider> {
    @Override
    protected ItemSoldReportSearcher createSearchFilter() {
        ItemSoldReportSearcher searcher = new ItemSoldReportSearcher();
        searcher.getTradingDayDateRangeFilter().setStart(DateTimeUtils.getStartDateForThisWeek());
        searcher.getTradingDayDateRangeFilter().setEnd(DateTimeUtils.getEndDateForWeek(DateTimeUtils.getStartDateForThisWeek()));
        return searcher;
    }

    @Override
    protected ItemSoldReportProvider createReportProvider(ItemSoldReportSearcher yourSearcher) {
        ItemSoldReportCompiler theCompiler = new ItemSoldReportCompiler(yourSearcher);
        return new ItemSoldReportProvider(theCompiler);
    }

    @Override
    public List<Pair<String, ReportMakerUtility.TabulatedReport>> tabulateResults(ItemSoldReportProvider provider) throws BuilderException {
        List<Pair<String, ReportMakerUtility.TabulatedReport>> results = super.tabulateResults(provider);
        if (!results.isEmpty()) {
            results.add(new Pair<String, ReportMakerUtility.TabulatedReport>("Report Totals", this.createSalesTotalReport(provider)));
        }
        return results;
    }

    private ReportMakerUtility.TabulatedReport createSalesTotalReport(ItemSoldReportProvider provider) {
        String[] headers = new String[]{"Discounts", "Surcharges", "Sales Total(Inc TAX)", "TAX"};
        List resultsData = (List)provider.getParameters().get("salesTotalSource");
        Object[][] data = new Object[resultsData.size() + 1][headers.length];
        data[0] = headers;
        for (int i = 0; i < resultsData.size(); ++i) {
            SalesTotalsHolder totals = (SalesTotalsHolder)resultsData.get(i);
            data[i + 1] = new BigDecimal[]{totals.getDiscountPrice().toBigDecimal(), totals.getSurchargePrice().toBigDecimal(), totals.getGrandTotalPrice().toBigDecimal(), totals.getTaxPrice().toBigDecimal()};
        }
        ReportMakerUtility.TabulatedReportMetaData metaData = new ReportMakerUtility.TabulatedReportMetaData();
        for (int i = 0; i < headers.length; ++i) {
            metaData.getColumnMetaData().add(new ReportMakerUtility.ReportColumnMetaData(headers[i], Number.class.getSimpleName().toLowerCase(), "$#,##0.00", -1, false, false));
        }
        return new ReportMakerUtility.TabulatedReport(data, metaData);
    }
}

