/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general.itemsold;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.builder.DJBar3DChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.sales.general.itemsold.ItemSoldHelper;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReport;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportCompiler;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.ListDataSourceProvider;
import ordermate.reports.printing.HeaderSubReport;

public class ItemSoldReportProvider
extends AbstractReportProvider {
    private final ListDataSourceProvider provider;
    private final ItemSoldReportCompiler compiler;
    private ReportBuilder builder;
    private ReportBuilder builderWithCOGS;
    private User user;
    private List<ItemSoldReport> currentReportItems;
    private DynamicReport report;
    private PeriodReportAdapter period;
    private boolean showCOGS = SystemProperty.getInstance().isStockControlEnabled();
    public static final String MENU_SECTION_COLUMN_NAME = "Menu Section";
    public static final String MENU_ITEM_COLUMN_NAME = "Menu Item";
    public static final String MENU_ID_COLUMN_NAME = "Unit ID";
    public static final String SIZE_COLUMN_NAME = "Size";
    public static final String PORTION_COLUMN_NAME = "Portion";
    public static final String CATEGORY_COLUMN_NAME = "Category";
    public static final String UNIT_PRICE_COLUMN_NAME = "Unit Price";
    public static final String QUANTITY_COLUMN_NAME = "Quantity";
    public static final String SALES_COLUMN_NAME = "Sales";
    public static final String PERC_SALES_COLUMN_NAME = "% of Sales";
    public static final String VENUE_NAME = "Business Location";

    public ItemSoldReportProvider(ItemSoldReportCompiler theCompiler) {
        this(theCompiler, null);
    }

    public ItemSoldReportProvider(ItemSoldReportCompiler theCompiler, PeriodReportAdapter period) {
        this.provider = new ListDataSourceProvider(){

            @Override
            protected List getDataList() {
                return ItemSoldReportProvider.this.compiler.compile();
            }
        };
        this.compiler = theCompiler;
        this.period = period;
    }

    public void setShowCOGS(boolean showCOGS) {
        this.showCOGS = showCOGS;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        this.currentReportItems = this.compiler.compile();
        return new JRBeanCollectionDataSource(this.currentReportItems);
    }

    @Override
    public JasperPrint getReportPrint() throws JRException {
        try {
            return super.getReportPrint();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem with the ItemSoldReport, will rebuild and try again", (Throwable)ex);
            this.builder = null;
            this.builderWithCOGS = null;
            return super.getReportPrint();
        }
    }

    @Override
    public DynamicReport getReport() throws BuilderException {
        this.report = this.getBuilder().buildJasperReport();
        this.report.setTitle(this.generateTitle());
        this.report.setSubtitle(this.generateSubtitle());
        return this.report;
    }

    public ItemSoldReportSearcher getSearcher() {
        return this.compiler.getSearcher();
    }

    public ItemSoldReportCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public synchronized ReportBuilder getBuilder() throws BuilderException {
        if (this.builder == null || this.builder.getColumnCount() == 0) {
            this.builder = new ReportBuilder();
            this.initBuilder(this.builder);
        }
        if (this.builderWithCOGS == null || this.builderWithCOGS.getColumnCount() == 0) {
            this.builderWithCOGS = new ReportBuilder();
            this.initBuilder(this.builderWithCOGS);
            this.builderWithCOGS.addReportColumn(ItemSoldReport.Properties.TOTAL_COGS, "COGS", Internationalization.getLiteralFor("PRICE_PATTERN"));
            this.builderWithCOGS.addReportColumn(ItemSoldReport.Properties.TOTAL_COGS_PERCENTAGE, "COGS %", "0.0%");
        }
        if (this.showCOGS) {
            return this.builderWithCOGS;
        }
        return this.builder;
    }

    private String generateTitle() {
        return (this.period == null ? "" : this.period.getLabel() + " ") + "Item Sold Report";
    }

    private synchronized void initBuilder(ReportBuilder toInitialise) throws BuilderException {
        toInitialise.addBusinessLogoDetailHeaderAndFooterTemplate();
        this.getParameters().putAll(new HeaderSubReport().getParamsMap());
        if (this.user != null) {
            this.addParam("user", this.user.getName());
        }
        toInitialise.setTitle(this.generateTitle());
        toInitialise.setSubtitle(this.generateSubtitle());
        this.addReportColumns(toInitialise);
        ItemSoldHelper.addCategoryTotalsReport(toInitialise, false);
        ItemSoldHelper.addSalesTotalReport(toInitialise);
    }

    protected void addReportColumns(ReportBuilder toInitialise) throws BuilderException {
        toInitialise.addReportColumn(ItemSoldReport.Properties.MENU_SECTION, MENU_SECTION_COLUMN_NAME, null);
        if (ExperimentalFeatureHelper.isShowItemIds()) {
            toInitialise.addReportColumn(ItemSoldReport.Properties.UNIT_ID, MENU_ID_COLUMN_NAME, null);
        }
        ArrayList<PropertiedObject.Property> props = new ArrayList<PropertiedObject.Property>(Arrays.asList(ItemSoldReport.Properties.INVENTORY_ITEM_NAME, ItemSoldReport.Properties.INVENTORY_SIZE_NAME, ItemSoldReport.Properties.INVENTORY_PORTION_NAME, ItemSoldReport.Properties.INVENTORY_CATEGORY, ItemSoldReport.Properties.UNIT_PRICE, ItemSoldReport.Properties.QUANTITY_SOLD, ItemSoldReport.Properties.SALES_VALUE_RAW, ItemSoldReport.Properties.SALES_PERC));
        String[] names = new String[]{MENU_ITEM_COLUMN_NAME, SIZE_COLUMN_NAME, PORTION_COLUMN_NAME, CATEGORY_COLUMN_NAME, UNIT_PRICE_COLUMN_NAME, QUANTITY_COLUMN_NAME, SALES_COLUMN_NAME, PERC_SALES_COLUMN_NAME};
        toInitialise.addReportColumns(props, names);
        toInitialise.getPropertyColumn(ItemSoldReport.Properties.SALES_VALUE_RAW).setPattern(Internationalization.getLiteralFor("PRICE_PATTERN"));
        toInitialise.getPropertyColumn(ItemSoldReport.Properties.UNIT_PRICE).setPattern(Internationalization.getLiteralFor("PRICE_PATTERN"));
        toInitialise.getPropertyColumn(ItemSoldReport.Properties.QUANTITY_SOLD).setPattern("0.00");
        toInitialise.getPropertyColumn(ItemSoldReport.Properties.SALES_PERC).setPattern("0.00%");
        if ("1".equals(ReportProperty.find(ReportGroup.ItemSold, "Include Business Location").getValue())) {
            toInitialise.addReportColumn(ItemSoldReport.Properties.BUSINESS_LOCATION, VENUE_NAME, null);
        }
        this.addGroupByAndChart(toInitialise);
    }

    private String generateSubtitle() {
        ItemSoldReportSearcher searcher = this.compiler.getSearcher();
        StringBuilder SB = new StringBuilder(this.getDisplayableDate());
        TimeSearchFilter timeFilter = searcher.getSalesTimeRangeFilter();
        String timeString = timeFilter.getDisplayableTime();
        ReportProviderHelper helper = this.getHelper();
        helper.appendSubTitleAndValue(SB, "Day Part", timeString);
        helper.appendSearchFilter(SB, "User", searcher.getUserFilter());
        helper.appendSearchFilter(SB, "Account Type", searcher.getAccountTypeFilter());
        helper.appendSearchFilter(SB, MENU_SECTION_COLUMN_NAME, searcher.getMenuSectionFilter());
        helper.appendSearchFilter(SB, CATEGORY_COLUMN_NAME, searcher.getCategoryFilter());
        helper.appendSearchFilter(SB, "Shift", searcher.getShiftFilter());
        helper.appendSearchFilter(SB, "Customer Category", searcher.getCustomerCategoryFilter());
        helper.appendSearchFilter(SB, "Customer Group", searcher.getCustomerGroupFilter());
        helper.appendSearchFilter(SB, "Terminals", searcher.getTerminalFilter());
        helper.appendSearchFilter(SB, "Sales Location", searcher.getSalesLocationFilter());
        helper.appendSearchFilter(SB, "Price Level", searcher.getPriceLevelFilter());
        helper.appendSearchFilter(SB, SIZE_COLUMN_NAME, searcher.getSizeFilter());
        helper.appendSearchFilter(SB, "Text Search", searcher.getItemNameFilter());
        return SB.toString();
    }

    public String getDisplayableDate() {
        IRangedSearchFilter dateRangeFilter = this.compiler.getSearcher().getTradingDayDateRangeFilter();
        IRangedQuerySearchFilter<Date> dateRangeAdapter = this.compiler.getSearcher().getTradingDayDateRangeAdapter();
        if (this.period != null && dateRangeFilter.hasSearchValue()) {
            return this.period.formatTradingDayRangeForDisplay((Date)dateRangeFilter.getStart(), (Date)dateRangeFilter.getEnd(), (Date)dateRangeAdapter.getEnd());
        }
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this.compiler.getSearcher());
    }

    protected DJGroup addGroupByAndChart(ReportBuilder toInitialise) throws BuilderException {
        DJGroup group = toInitialise.addGroupBy(ItemSoldReport.Properties.MENU_SECTION, Arrays.asList(new ReportBuilder.PropertyCalculation(ItemSoldReport.Properties.SALES_VALUE_RAW, DJCalculation.SUM), new ReportBuilder.PropertyCalculation(ItemSoldReport.Properties.QUANTITY_SOLD, DJCalculation.SUM)));
        toInitialise.addGroupStaticText("Total", group, (AbstractColumn)toInitialise.getPropertyColumn(ItemSoldReport.Properties.INVENTORY_PORTION_NAME));
        if (group != null) {
            PropertyColumn column = toInitialise.getPropertyColumn(ItemSoldReport.Properties.MENU_SECTION);
            DJBar3DChartBuilder chartBuilder = new DJBar3DChartBuilder();
            chartBuilder.setX(20).setY(10).setWidth(500).setHeight(500).setCentered(true).setBackColor(Color.LIGHT_GRAY).setShowLegend(true).setPosition((byte)2).setTitle("Items Sold").setTitleColor(Color.DARK_GRAY).setLegendColor(Color.DARK_GRAY).setLegendBackgroundColor(Color.WHITE).setLegendPosition((byte)2).setTitlePosition((byte)1).setLineStyle((byte)2).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5).setCategory(column).setValueAxisFormat(new DJAxisFormat("Sales (" + Internationalization.getLiteralFor("DOLLAR_SIGN") + ")")).addSerie((AbstractColumn)toInitialise.getPropertyColumn(ItemSoldReport.Properties.SALES_VALUE_RAW));
            DJChart build = chartBuilder.build();
            build.getPlot().setLabelRotation(Double.valueOf(90.0));
            toInitialise.getReportBuilder().addChart(build);
        }
        return group;
    }

    @Override
    public Map<String, Object> getParameters() {
        Map<String, Object> map = super.getParameters();
        if (this.currentReportItems != null) {
            ItemSoldHelper.addCategoryTotalsParams(map, this.currentReportItems);
            ItemSoldHelper.addSalesTotalsParams(map, this.currentReportItems);
        }
        return map;
    }

    protected List<ItemSoldReport> getCurrentReportItems() {
        return Collections.unmodifiableList(this.currentReportItems != null ? this.currentReportItems : Collections.emptyList());
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.compiler.getSearcher().getTradingDayDateRangeFilter()) + System.getProperty("line.separator") + "Prices include discounts & surcharges that may not have been applied within the selected period.";
    }
}

