/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general.itemsold;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReport;

public class ItemSoldSummaryReport
extends PersistentSummaryObject
implements Comparable {
    public static final Props Properties = new Props();
    private InventoryGroup inventoryGroup;
    private Price salesValue;
    private Double quantitySold;
    private Double percOfSales;
    private Price totalCogs;
    private String inventoryGroupName = "";

    public ItemSoldSummaryReport(InventoryGroup theGroup) {
        this.setInventoryGroup(theGroup);
        this.setSalesValue(Price.ZERO_NO_ROUND);
        this.setTotalCogs(Price.ZERO_NO_ROUND);
        this.setQuantitySold(0.0);
        this.setPercOfSales(0.0);
    }

    public ItemSoldSummaryReport(String groupName) {
        this.inventoryGroupName = groupName;
        this.setSalesValue(Price.ZERO_NO_ROUND);
        this.setTotalCogs(Price.ZERO_NO_ROUND);
        this.setQuantitySold(0.0);
        this.setPercOfSales(0.0);
    }

    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup;
    }

    protected void setInventoryGroup(InventoryGroup value) {
        this.inventoryGroup = value;
    }

    public Price getSalesValue() {
        return this.salesValue;
    }

    protected void setSalesValue(Price newValue) {
        this.salesValue = newValue;
    }

    public Double getQuantitySold() {
        return this.quantitySold;
    }

    protected void setQuantitySold(Double value) {
        this.quantitySold = value;
    }

    public Double getPercOfSales() {
        return this.percOfSales;
    }

    protected void setPercOfSales(Double value) {
        this.percOfSales = value;
    }

    public void setTotalSales(Price totalSales) {
        this.percOfSales = this.salesValue.doubleValue() / totalSales.doubleValue();
    }

    public BigDecimal getSalesTotalRaw() {
        return this.getSalesValue().toBigDecimal();
    }

    public String getGroupName() {
        return this.getInventoryGroup() != null ? this.getInventoryGroup().getLabel() : this.inventoryGroupName;
    }

    protected ObjectQuery getSummaryQuery() {
        return null;
    }

    public void addItemSoldReport(ItemSoldReport report) {
        this.salesValue = this.salesValue.add(report.getSalesValue());
        this.quantitySold = this.quantitySold + report.getQuantitySold().doubleValue();
        this.totalCogs = this.totalCogs.add(report.getTotalCogs());
    }

    public int compareTo(Object o) {
        String comparisonString = o instanceof ItemSoldSummaryReport ? ((ItemSoldSummaryReport)o).getInventoryGroup().getLabel() : String.valueOf(o);
        return comparisonString.compareTo(this.inventoryGroup.getLabel());
    }

    public String getDummyGroup() {
        return "";
    }

    public Price getTotalCogs() {
        return this.totalCogs;
    }

    protected void setTotalCogs(Price totalCogs) {
        this.totalCogs = totalCogs;
    }

    public Double getTotalCogsPercentage() {
        if (this.totalCogs != null && this.salesValue != null) {
            if (this.salesValue.isZero()) {
                return 1.0;
            }
            return this.totalCogs.divide(this.salesValue).doubleValue();
        }
        return 0.0;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property INVENTORY_GROUP;
        public PropertiedObject.Property SALES_VALUE;
        public PropertiedObject.Property QUANTITY_SOLD;
        public PropertiedObject.Property PERC_OF_SALES;
        public PropertiedObject.Property<Price> TOTAL_COGS;
        public PersistentObject.DerivedProperty<ItemSoldSummaryReport> INVENTORY_GROUP_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldSummaryReport.class), "groupName");
        public PersistentObject.DerivedProperty<ItemSoldSummaryReport> DUMMY_GROUP = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldSummaryReport.class), "dummyGroup");
        public PersistentObject.DerivedProperty<Double> TOTAL_COGS_PERCENTAGE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemSoldSummaryReport.class), "totalCogsPercentage");
    }
}

