/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general.itemunsold;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.misc.TradingDay;

public class ItemUnsoldReport
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<InventoryItem> item;
    private Reference<InventoryGroup> inventoryGroup;
    private Reference<InventoryCategory> inventoryCategory;
    private Reference<InventoryItemSize> size;
    private Reference<InventoryItemPortion> portion;
    private Reference<TradingDay> tradingDay;
    private Long unitId;
    private String inventoryItemName;
    private String inventoryGroupName;
    private String inventoryPortionName;
    private String inventorySizeName;
    private String categoryName;
    private BigDecimal quantitySold;
    private Price itemPrice;
    private Price GPValue;
    private Double GPPercent;
    private Date reportDate;

    public ItemUnsoldReport() {
        this.item = this.createReference(ItemUnsoldReport.Properties.ITEM);
        this.inventoryGroup = this.createReference(ItemUnsoldReport.Properties.INVENTORY_GROUP);
        this.inventoryCategory = this.createReference(ItemUnsoldReport.Properties.INVENTORY_CATEGORY);
        this.size = this.createReference(ItemUnsoldReport.Properties.SIZE);
        this.portion = this.createReference(ItemUnsoldReport.Properties.PORTION);
        this.tradingDay = this.createReference(ItemUnsoldReport.Properties.TRADING_DAY);
        this.inventoryItemName = "";
        this.inventoryGroupName = "";
        this.inventoryPortionName = "";
        this.inventorySizeName = "";
        this.categoryName = "";
        this.quantitySold = BigDecimal.ZERO;
        this.itemPrice = Price.ZERO_NO_ROUND;
        this.GPValue = Price.ZERO_NO_ROUND;
    }

    @Override
    public void init() {
        this.getInventoryGroup();
        super.init();
    }

    public Long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(Long value) {
        this.unitId = value;
    }

    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    public InventoryCategory getInventoryCategory() {
        return this.inventoryCategory.get();
    }

    public InventoryItemSize getSize() {
        return this.size.get();
    }

    public InventoryItemPortion getPortion() {
        return this.portion.get();
    }

    public InventoryItem getItem() {
        return this.item.get();
    }

    protected void setItem(InventoryItem value) {
        this.item.set(value);
    }

    public String getInventoryItemName() {
        return this.inventoryItemName;
    }

    public String getMenuSection() {
        return this.getInventoryGroup() != null ? this.getInventoryGroup().getLabel() : this.inventoryGroupName;
    }

    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    public void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    protected void setInventoryCategory(InventoryCategory cat) {
        this.inventoryCategory.set(cat);
    }

    protected void setInventoryGroup(InventoryGroup group) {
        this.inventoryGroup.set(group);
    }

    protected void setInventoryItemName(String name) {
        this.inventoryItemName = name;
    }

    protected void setPortion(InventoryItemPortion inventoryPortion) {
        this.portion.set(inventoryPortion);
    }

    protected void setSize(InventoryItemSize invSize) {
        this.size.set(invSize);
    }

    public BigDecimal getQuantitySold() {
        return this.quantitySold;
    }

    public void setQuantitySold(BigDecimal qty) {
        this.quantitySold = qty;
    }

    public Date getReportDate() {
        return this.reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public void addReport(ItemUnsoldReport report) {
        this.setTradingDay(null);
        this.quantitySold = this.quantitySold.add(report.getQuantitySold());
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (!this.tradingDay.isNull()) {
            PersistenceManager.save(this);
        }
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    protected synchronized void setID(Long newID) {
        if (newID != null && newID == 0L) {
            super.setID(null);
        } else {
            super.setID(newID);
        }
    }

    public String getInventoryGroupName() {
        return this.inventoryGroupName;
    }

    protected void setInventoryGroupName(String inventoryGroupName) {
        this.inventoryGroupName = inventoryGroupName;
    }

    public String getInventoryPortionName() {
        return this.inventoryPortionName;
    }

    protected void setInventoryPortionName(String inventoryPortionName) {
        this.inventoryPortionName = inventoryPortionName;
    }

    public String getInventorySizeName() {
        return this.inventorySizeName;
    }

    protected void setInventorySizeName(String inventorySizeName) {
        this.inventorySizeName = inventorySizeName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    protected void setCategoryName(String value) {
        this.categoryName = value;
    }

    public Price getItemPrice() {
        return this.itemPrice;
    }

    public void setItemPrice(Price itemPrice) {
        this.itemPrice = itemPrice;
    }

    public Price getGPValue() {
        return this.GPValue;
    }

    public void setGPValue(Price gPValue) {
        this.GPValue = gPValue;
    }

    public Double getGPPercent() {
        return this.GPPercent;
    }

    public void setGPPercent(Double gPPercent) {
        this.GPPercent = gPPercent;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<InventoryCategory> INVENTORY_CATEGORY;
        public PropertiedObject.Property<String> INVENTORY_ITEM_NAME;
        public PropertiedObject.Property<InventoryItem> ITEM;
        public PropertiedObject.Property<InventoryItemSize> SIZE;
        public PropertiedObject.Property<InventoryItemPortion> PORTION;
        public PropertiedObject.Property<Long> UNIT_ID;
        public PropertiedObject.Property<BigDecimal> QUANTITY_SOLD;
        public PropertiedObject.Property<Price> ITEM_PRICE;
        public PropertiedObject.Property<Price> GP_VALUE;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Date> REPORT_DATE;
        public PropertiedObject.Property<String> INVENTORY_GROUP_NAME;
        public PropertiedObject.Property<String> INVENTORY_SIZE_NAME;
        public PropertiedObject.Property<String> INVENTORY_PORTION_NAME;
        public PropertiedObject.Property<String> CATEGORY_NAME;
        public PersistentObject.DerivedProperty MENU_SECTION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemUnsoldReport.class), "menuSection");
        public PersistentObject.DerivedProperty<Double> GP_PERCENT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemUnsoldReport.class), "GPPercent");
    }
}

