/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.general.itemunsold;

import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.reports.ReportConfigureColumnMetaData;
import au.com.ordermate.util.DateTimeUtils;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.sales.general.itemunsold.ItemUnsoldReportProvider;
import ordermate.database.searchers.reports.sales.general.itemunsold.ItemUnsoldReportCompiler;
import ordermate.database.searchers.reports.sales.general.itemunsold.ItemUnsoldReportSearcher;

@MakesReport(value="Unsold Items", description="show the items that were not purchased or lower than one quantity in the time range including inventory item info ,quantity sold, item price, total sales value % of sales, GP and GP %", category="Sales & Takings", subcategory="Sales", columnMetaData={@ReportConfigureColumnMetaData(name="Unit ID", grouped=0), @ReportConfigureColumnMetaData(name="Menu Section", grouped=0), @ReportConfigureColumnMetaData(name="Menu Item", locked=true), @ReportConfigureColumnMetaData(name="Size", grouped=1), @ReportConfigureColumnMetaData(name="Portion", grouped=2), @ReportConfigureColumnMetaData(name="Category", grouped=3), @ReportConfigureColumnMetaData(name="Item Price"), @ReportConfigureColumnMetaData(name="Quantity", totaled=true), @ReportConfigureColumnMetaData(name="GP", totaled=true), @ReportConfigureColumnMetaData(name="GP %")})
public class ItemUnsoldReportMaker
extends ConfigurableReportMaker<ItemUnsoldReportSearcher, ItemUnsoldReportProvider> {
    @Override
    protected ItemUnsoldReportSearcher createSearchFilter() {
        ItemUnsoldReportSearcher searcher = new ItemUnsoldReportSearcher();
        searcher.getTradingDayDateRangeFilter().setStart(DateTimeUtils.getStartDateForThisWeek());
        searcher.getTradingDayDateRangeFilter().setEnd(DateTimeUtils.getEndDateForWeek(DateTimeUtils.getStartDateForThisWeek()));
        return searcher;
    }

    @Override
    protected ItemUnsoldReportProvider createReportProvider(ItemUnsoldReportSearcher yourSearcher) {
        ItemUnsoldReportCompiler theCompiler = new ItemUnsoldReportCompiler(yourSearcher);
        return new ItemUnsoldReportProvider(theCompiler);
    }
}

