/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.staff;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.queries.sales.StaffItemReportQueries;
import ordermate.database.reports.sales.staff.AbstractStaffSoldReport;

public class StaffDeletedItemsReport
extends AbstractStaffSoldReport {
    public static final Props Properties = new Props();
    private Reference<InventoryItemUnit> inventoryItemUnit;
    private String size;
    private String portion;
    private Date dateDeleted;
    private Date orderedTime;
    private String orderedUser;
    private String deletedUser;
    private Long account;

    public StaffDeletedItemsReport() {
        this.inventoryItemUnit = this.createReference(StaffDeletedItemsReport.Properties.INVENTORY_ITEM_UNIT);
    }

    public Long getAccount() {
        return this.account;
    }

    public void setAccount(Long account) {
        this.account = account;
    }

    public Date getOrderedTime() {
        return this.orderedTime;
    }

    public void setOrderedTime(Date orderedTime) {
        this.orderedTime = orderedTime;
    }

    public String getOrderedUser() {
        return this.orderedUser;
    }

    public void setOrderedUser(String orderedUser) {
        this.orderedUser = orderedUser;
    }

    public String getDeletedUser() {
        return this.deletedUser;
    }

    public void setDeletedUser(String deletedUser) {
        this.deletedUser = deletedUser;
    }

    public Date getDateDeleted() {
        return this.dateDeleted;
    }

    public void setDateDeleted(Date newDateDeleted) {
        this.dateDeleted = newDateDeleted;
    }

    public String getReportingDateDeleted() {
        return DateTimeUtils.get24HFormat().format(this.getDateDeleted()) + " " + DateTimeUtils.getLongFormat().format(this.getDateDeleted());
    }

    protected static ObjectQuery getSummaryQuery() {
        return StaffItemReportQueries.deletedItemsSummaryQuery();
    }

    public InventoryItemUnit getInventoryItemUnit() {
        return this.inventoryItemUnit.get();
    }

    public void setInventoryItemUnit(InventoryItemUnit unit) {
        this.inventoryItemUnit.set(unit);
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getPortion() {
        return this.portion;
    }

    public void setPortion(String portion) {
        this.portion = portion;
    }

    @Override
    public String getFormattedLabel() {
        StringBuilder SB = new StringBuilder();
        SB.append(this.getInventoryItemUnit().getItemLabel()).append(" (").append(this.getSize()).append(", ").append(this.getPortion()).append(")");
        return SB.toString();
    }

    public static class Props
    extends AbstractStaffSoldReport.Props {
        public PersistentObject.DerivedProperty<String> FORMATTED_LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StaffDeletedItemsReport.class), "formattedLabel");
        public PropertiedObject.Property<Date> DATE_DELETED;
        public PersistentObject.DerivedProperty<String> REPORTING_DATE_DELETED = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StaffDeletedItemsReport.class), "reportingDateDeleted");
        public PersistentObject.DerivedProperty<String> FULLNAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StaffDeletedItemsReport.class), "fullName");
        public PersistentObject.DerivedProperty<BigDecimal> TOTAL_RAW_VALUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StaffDeletedItemsReport.class), "totalRawValue");
        public PropertiedObject.Property<InventoryItemUnit> INVENTORY_ITEM_UNIT;
        public PropertiedObject.Property SIZE;
        public PropertiedObject.Property PORTION;
        public PersistentObject.DerivedProperty<Long> ACCOUNT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StaffDeletedItemsReport.class), "account");
        public PersistentObject.DerivedProperty<Date> ORDERED_TIME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StaffDeletedItemsReport.class), "orderedTime");
        public PersistentObject.DerivedProperty<String> ORDERED_USER = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StaffDeletedItemsReport.class), "orderedUser");
        public PersistentObject.DerivedProperty<String> DELETED_USER = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StaffDeletedItemsReport.class), "deletedUser");
    }
}

