/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.staff;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import ordermate.database.reports.sales.staff.StaffDeletedItemsReport;

public class StaffDeletedItemsReportSummary
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private String fullName;
    private BigDecimal totalQty;
    private Price totalTotals;

    public StaffDeletedItemsReportSummary() {
    }

    public StaffDeletedItemsReportSummary(String fullName) {
        this.fullName = fullName;
        this.totalTotals = new Price(0.0, 0.01);
        this.totalQty = new BigDecimal(0);
    }

    public void addReport(StaffDeletedItemsReport report) {
        this.totalTotals = this.totalTotals.add(report.getTotal());
        this.totalQty = new BigDecimal(this.totalQty.intValue() + report.getQuantity().intValue());
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public BigDecimal getTotalQty() {
        return this.totalQty;
    }

    public void setTotalQty(BigDecimal totalQty) {
        this.totalQty = totalQty;
    }

    public Price getTotalTotals() {
        return this.totalTotals;
    }

    public void setTotalTotals(Price totalTotals) {
        this.totalTotals = totalTotals;
    }

    public Double getRawTotal() {
        return this.totalTotals.doubleValue();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property FULL_NAME;
        public PropertiedObject.Property TOTAL_QTY;
        public PropertiedObject.Property TOTAL_TOTALS;
        public PersistentObject.DerivedProperty<Double> RAW_TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StaffDeletedItemsReportSummary.class), "rawTotal");
    }
}

