/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.time;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.offset.DateOffsetFunction;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@AccessType(value="property")
public class SalesHistoryReport
extends PersistentSummaryObject
implements Comparable<SalesHistoryReport> {
    public static final Props Properties = new Props();
    private DateOffsetFunction offset;
    private Date lastSale;
    private Price salesValue;

    public SalesHistoryReport(DateOffsetFunction offset, Date lastSale, Price salesValue) {
        this.offset = offset;
        this.lastSale = lastSale;
        this.salesValue = salesValue;
    }

    public SalesHistoryReport() {
    }

    @Transient
    public DateOffsetFunction getOffset() {
        return this.offset;
    }

    public void setOffset(DateOffsetFunction dateOffset) {
        this.offset = dateOffset;
    }

    @Column(name="last_sale")
    @Temporal(value=TemporalType.DATE)
    public Date getLastSale() {
        return this.lastSale;
    }

    protected void setLastSale(Date value) {
        this.lastSale = value;
    }

    @Column(name="sales_value")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getSalesValue() {
        return this.salesValue;
    }

    protected void setSalesValue(Price value) {
        this.salesValue = value;
    }

    @Transient
    public Calendar getPeriodStart() {
        if (this.offset == null || this.lastSale == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.offset.calcStart(this.getLastSaleAsCalendar().getTime()));
        return cal;
    }

    @Transient
    public Date getPeriodStartDate() {
        Calendar cal = this.getPeriodStart();
        return cal == null ? null : cal.getTime();
    }

    @Transient
    private Calendar getLastSaleAsCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.lastSale);
        return cal;
    }

    @Transient
    public BigDecimal getSalesValueRaw() {
        return this.salesValue == null ? BigDecimal.ZERO : this.salesValue.toBigDecimal();
    }

    @Override
    public int compareTo(SalesHistoryReport o) {
        if (o == null) {
            o = new SalesHistoryReport();
        }
        return new CompareToBuilder().append((Object)this.getPeriodStart(), (Object)o.getPeriodStart()).toComparison();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SalesHistoryReport)) {
            return false;
        }
        SalesHistoryReport that = (SalesHistoryReport)o;
        return !(this.lastSale != null ? !this.lastSale.equals(that.lastSale) : that.lastSale != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.lastSale != null ? this.lastSale.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "SalesHistoryReport{lastSale=" + this.lastSale + ", salesValue=" + this.salesValue + (this.offset != null ? ", periodStart = " + this.getPeriodStartDate() : "") + '}';
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property LAST_SALE;
        public PropertiedObject.Property SALES_VALUE;
        public PersistentObject.DerivedProperty<Date> PERIOD_START_DATE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesHistoryReport.class), "periodStartDate");
        public PersistentObject.DerivedProperty<BigDecimal> SALES_VALUE_RAW = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesHistoryReport.class), "salesValueRaw");
    }
}

