/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.yearonyear;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;

public class SalesYearOnYearReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Date period;
    private Price salesValue = Price.ZERO_DOLLAR;
    private Price diffToPrevious;

    public Date getPeriod() {
        return this.period;
    }

    public void setPeriod(Date year) {
        this.period = year;
    }

    public Price getSalesValue() {
        if (this.salesValue == null) {
            return Price.ZERO_DOLLAR;
        }
        return this.salesValue;
    }

    public Price getDiffToPrevious() {
        return this.diffToPrevious;
    }

    public void setDiffToPrevious(Price diffToPrevious) {
        this.diffToPrevious = diffToPrevious;
    }

    public void setDiffToPrevious(SalesYearOnYearReport previous) {
        if (previous == null) {
            this.diffToPrevious = this.getSalesValue();
            return;
        }
        this.diffToPrevious = this.getSalesValue().subtract(previous.getSalesValue());
    }

    public String getDiffToPreviousPercent() {
        if (this.diffToPrevious == null) {
            return null;
        }
        Price diff = this.getDiffToPrevious();
        if (diff == null || diff.isZero()) {
            return null;
        }
        Price lastYearsSales = this.getSalesValue().subtract(diff);
        if (lastYearsSales.equals(Price.ZERO_DOLLAR)) {
            return null;
        }
        return this.diffToPrevious.divide(lastYearsSales).multiply(100).toString(false) + "%";
    }

    public BigDecimal getSalesValueRaw() {
        return this.getSalesValue().toBigDecimal();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Date> PERIOD;
        public PropertiedObject.Property<Price> SALES_VALUE;
        public PropertiedObject.Property<Price> DIFF_TO_PREVIOUS;
        public PersistentObject.DerivedProperty<String> DIFF_TO_PREVIOUS_PC = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesYearOnYearReport.class), "diffToPreviousPercent");
        public PersistentObject.DerivedProperty SALES_VALUE_RAW = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesYearOnYearReport.class), "salesValueRaw");
    }
}

