/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sales.yearonyear;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.builder.DJLineChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.sales.yearonyear.SalesYearOnYearReport;
import ordermate.database.searchers.reports.sales.time.SalesYearOnYearReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class SalesYearOnYearReportProvider
extends AbstractReportProvider {
    private ReportBuilder builder;
    private SearcherDataSourceProvider<SalesYearOnYearReportSearcher> datasourceProvider;
    private PeriodReportAdapter periodReport;

    public SalesYearOnYearReportProvider(SalesYearOnYearReportSearcher searcher, PeriodReportAdapter period) {
        this.datasourceProvider = new SearcherDataSourceProvider<SalesYearOnYearReportSearcher>(searcher);
        this.periodReport = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        SalesYearOnYearReportProvider salesYearOnYearReportProvider = this;
        synchronized (salesYearOnYearReportProvider) {
            if (this.builder == null) {
                this.initBuilder();
            }
        }
        StringBuilder SB = new StringBuilder(this.periodReport.formatDateForDisplay((Date)this.getSearcher().getTradingDayDateRangeAdapter().getStart()));
        SalesYearOnYearReportSearcher searcher = this.getSearcher();
        String time = searcher.getTimeFilter().getDisplayableTime();
        this.getHelper().appendSubTitleAndValue(SB, "Time", time);
        this.getHelper().appendSearchFilter(SB, "Customer Type", searcher.getCustomerTypeFilter());
        this.getHelper().appendSearchFilter(SB, "Section", searcher.getMenuSectionFilter());
        this.getHelper().appendSearchFilter(SB, "Price Level", searcher.getPriceLevelFilter());
        this.getHelper().appendSearchFilter(SB, "Shift", searcher.getShiftFilter());
        this.getHelper().appendSearchFilter(SB, "Terminal", searcher.getTerminalFilter());
        this.getHelper().appendRangeSearchFilter(SB, "Time", searcher.getTimeFilter(), this.getHelper().getTimeFormat());
        this.getHelper().appendSearchFilter(SB, "Customers", searcher.getCustomerFilter());
        this.getHelper().appendSearchFilter(SB, "Sales Location", searcher.getSalesLocationFilter());
        this.builder.setSubtitle(SB.toString());
        return this.builder;
    }

    private void initBuilder() throws BuilderException {
        this.builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        this.builder.getCustomExpressionRegister().put(Date.class, new DateExpressionBuilder(this.periodReport.getFormatter()));
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        this.builder.setTitle(this.periodReport.getLabel() + " Sales Year On Year Report");
        this.builder.addReportColumn(SalesYearOnYearReport.Properties.PERIOD, "Date", ((SimpleDateFormat)this.periodReport.getFormatter()).toPattern());
        this.builder.addReportColumns(new ArrayList<PropertiedObject.Property>(){
            {
                this.add(SalesYearOnYearReport.Properties.SALES_VALUE);
                this.add(SalesYearOnYearReport.Properties.DIFF_TO_PREVIOUS);
                this.add(SalesYearOnYearReport.Properties.DIFF_TO_PREVIOUS_PC);
            }
        }, "Sales Value", "Diff", "Diff %");
        PersistentObject.DerivedProperty graphValue = SalesYearOnYearReport.Properties.SALES_VALUE_RAW;
        this.builder.addInvisibleField(graphValue);
        this.builder.getPropertyColumn(SalesYearOnYearReport.Properties.SALES_VALUE).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        this.builder.getPropertyColumn(SalesYearOnYearReport.Properties.DIFF_TO_PREVIOUS).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        DJChart chart = new DJLineChartBuilder().setValueAxisFormat(new DJAxisFormat(Internationalization.getLiteralFor("DOLLAR_SIGN"))).addSerie((AbstractColumn)this.builder.getPropertyColumn(graphValue), "Sales").setColumnGroup(this.builder.getPropertyColumn(SalesYearOnYearReport.Properties.PERIOD)).setPosition((byte)1).build();
        chart.getPlot().setLabelRotation(ReportBuilder.BAR_LABEL_ROTATION);
        this.builder.addChart(chart);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        DynamicReport report = this.getBuilder().buildJasperReport();
        return report;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.datasourceProvider.getDataSource();
    }

    protected SalesYearOnYearReportSearcher getSearcher() {
        return this.datasourceProvider.getSearch();
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeSingleValueFilter(this.getSearcher().getTradingDayIdFilter());
    }
}

