/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.saleshistory;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.builder.DJLineChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.sales.time.SalesHistoryReport;
import ordermate.database.reports.saleshistory.InvisibleXAxisChartCustomizer;
import ordermate.database.sales.Customer;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.searchers.reports.sales.time.SalesHistoryReportAggregator;
import ordermate.database.searchers.reports.sales.time.SalesHistoryReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class SalesHistoryReportProvider
extends AbstractReportProvider {
    private SearcherDataSourceProvider<SalesHistoryReportSearcher> searcherDataSourceProvider;
    private final PropertiedObject.Property salesValueProperty;
    private final PersistentObject.DerivedProperty<Date> dateProperty;
    private final PersistentObject.DerivedProperty<BigDecimal> salesValueForGraphProperty;
    private ReportBuilder reportBuilder;
    private DJChart chart;
    private static final int MAX_RESULTS_ON_X_AXIS = 24;

    public SalesHistoryReportProvider(SalesHistoryReportSearcher searcher) throws BuilderException {
        this.salesValueProperty = SalesHistoryReport.Properties.SALES_VALUE;
        this.dateProperty = SalesHistoryReport.Properties.PERIOD_START_DATE;
        this.salesValueForGraphProperty = SalesHistoryReport.Properties.SALES_VALUE_RAW;
        this.searcherDataSourceProvider = new SearcherDataSourceProvider<SalesHistoryReportSearcher>(searcher);
        this.initBuilder();
    }

    private void initBuilder() throws BuilderException {
        SalesHistoryReportSearcher reportSearcher = this.searcherDataSourceProvider.getSearch();
        PeriodReportAdapter period = reportSearcher.getPeriod();
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        DateFormat format = period.getFormatter();
        builder.getCustomExpressionRegister().put(Date.class, new DateExpressionBuilder(format));
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle(period.getLabel() + " Sales History Report");
        this.makeSubtitle(reportSearcher, period, builder);
        builder.addReportColumns(Arrays.asList(this.dateProperty, this.salesValueProperty), period.getUnitOfTime(), "Sales");
        builder.getPropertyColumn(this.salesValueProperty).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        builder.addInvisibleField(this.salesValueForGraphProperty);
        builder.getPropertyColumn(this.salesValueForGraphProperty).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        builder.setUseGrandTotal(true);
        builder.addFooterCalculation(new ReportBuilder.PropertyCalculation(this.salesValueProperty, DJCalculation.SUM));
        this.chart = new DJLineChartBuilder().setValueAxisFormat(new DJAxisFormat(Internationalization.getLiteralFor("DOLLAR_SIGN"))).addSerie((AbstractColumn)builder.getPropertyColumn(this.salesValueForGraphProperty), "Sales").setColumnGroup(builder.getPropertyColumn(this.dateProperty)).setPosition((byte)1).build();
        this.chart.getPlot().setLabelRotation(ReportBuilder.BAR_LABEL_ROTATION);
        builder.addChart(this.chart);
        this.reportBuilder = builder;
    }

    private void makeSubtitle(SalesHistoryReportSearcher reportSearcher, PeriodReportAdapter period, ReportBuilder builder) {
        StringBuilder subtitle = new StringBuilder();
        IRangedQuerySearchFilter<Date> dateRangeFilter = reportSearcher.getTradingDayDateRangeAdapter();
        IRangedQuerySearchFilter<Date> dateRangeAdapter = reportSearcher.getTradingDayDateRangeAdapter();
        ISingleValueSearchFilter<TradingDay> dayFilter = reportSearcher.getTradingDayFilter();
        String dateString = null;
        if (dateRangeFilter.hasSearchValue()) {
            dateString = period.formatTradingDayRangeForDisplay((Date)dateRangeFilter.getStart(), (Date)dateRangeFilter.getEnd(), (Date)dateRangeAdapter.getEnd());
        } else if (dayFilter.hasSearchValue()) {
            dateString = TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(reportSearcher);
        }
        subtitle.append(dateString);
        this.getHelper().appendSearchFilter(subtitle, "Shift", reportSearcher.getShiftFilter());
        this.getHelper().appendSearchFilter(subtitle, "Customer Categories", reportSearcher.getCustomerTypeFilter());
        this.getHelper().appendSearchFilter(subtitle, "Day of Week", reportSearcher.getDayOfWeekFilter());
        this.getHelper().appendSearchFilter(subtitle, "Week", reportSearcher.getWeekFilter());
        this.getHelper().appendSearchFilter(subtitle, "Month", reportSearcher.getMonthFilter());
        this.getHelper().appendSearchFilter(subtitle, "Quarter", reportSearcher.getQuarterFilter());
        this.getHelper().appendSearchFilter(subtitle, "Sales Location", reportSearcher.getSalesLocationFilter());
        if (reportSearcher.getCustomerFilter().hasSearchValue()) {
            subtitle.append("\\nFiltering ").append(reportSearcher.getCustomerFilter().getSelectedCount()).append(" Customers");
            this.listSelectedCustomers(reportSearcher, subtitle);
        }
        builder.setSubtitle(subtitle.toString());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.searcherDataSourceProvider.getDataSource();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        SalesHistoryReportSearcher searcher = this.searcherDataSourceProvider.getSearch();
        this.makeSubtitle(searcher, searcher.getPeriod(), this.reportBuilder);
        String customizerClass = null;
        if (searcher.getTradingDayDateRangeFilter().hasSearchValue() && this.isTooManyDataPoints(searcher)) {
            customizerClass = InvisibleXAxisChartCustomizer.class.getName();
        }
        this.chart.getOptions().setCustomizerClass(customizerClass);
        return this.reportBuilder;
    }

    private boolean isTooManyDataPoints(SalesHistoryReportSearcher searcher) {
        SalesHistoryReportAggregator aggregator = new SalesHistoryReportAggregator(searcher);
        int possibleResults = aggregator.insertEmptyDates((IRangedQuerySearchFilter<Date>)searcher.getTradingDayDateRangeFilter(), new ArrayList<SalesHistoryReport>()).size();
        return possibleResults > 24;
    }

    public void setUser(User user) {
        if (user != null) {
            this.addParam("user", user.getName());
        }
    }

    private void listSelectedCustomers(SalesHistoryReportSearcher reportSearcher, StringBuilder subtitle) {
        subtitle.append(": ");
        List options = reportSearcher.getCustomerFilter().getSelectedOptions();
        int optionsSize = options.size();
        for (int i = 0; i < optionsSize; ++i) {
            Customer cust = (Customer)options.get(i);
            subtitle.append(cust.getName().trim()).append(i < options.size() - 1 ? ", " : "");
        }
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.searcherDataSourceProvider.getSearch().getTradingDayDateRangeFilter());
    }
}

