/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.salestotakings;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.salestotakings.SalesToTakingsReport;

public class SalesToTakingsCompiler {
    private TradingDay searchTradingDay;
    private ObjectSearchFilter<Date> dateFilter = new ObjectSearchFilter(null);

    public TradingDay getSearchTradingDay() {
        return this.searchTradingDay;
    }

    public void setSearchTradingDay(TradingDay searchTradingDay) {
        this.searchTradingDay = searchTradingDay;
    }

    public List<List<String>> compile(TradingDay tradingDay) {
        this.searchTradingDay = tradingDay;
        ArrayList<List<String>> compilerResults = new ArrayList<List<String>>();
        SalesToTakingsReport report = new SalesToTakingsReport(this.searchTradingDay);
        List<String> lines = StringUtils.splitToList(report.getDocketString(), "\r\n");
        for (String nextLine : lines) {
            List<String> cells = StringUtils.splitToList(nextLine, "\t");
            compilerResults.add(cells);
        }
        return compilerResults;
    }

    @FilterConfig(name="Trading Day", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.DATE, nullAllowed=false, plural=FilterConfig.Plural.Single, priority=true, sequence=1)
    public ObjectSearchFilter<Date> getTradingDayFilter() {
        return this.dateFilter;
    }

    public List<List<String>> compile() {
        if (this.dateFilter.hasSearchValue()) {
            this.searchTradingDay = PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).equals(TradingDay.Properties.DATE, (Date)this.dateFilter.getSearchValue(), SQLDateType.DATE).toString());
        }
        if (this.searchTradingDay == null) {
            this.searchTradingDay = TradingDay.getCurrentTradingDay();
        }
        return this.compile(this.searchTradingDay);
    }
}

