/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.salestotakings;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.finance.reports.RestaurantTakingsSummaryQueryHelper;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.docketprocessor.DocketProcessor;

public class SalesToTakingsReport {
    private static final String ORPHAN_TXN = "* Orphaned Finance Transactions";
    private static final String FUTURE_DELETIONS = "* Sales Deleted In the Future";
    private static final String UNBALANCED_ACCOUNTS = "* Unbalanced Accounts";
    private static final String INCORRECT_TOTALS = "* Incorrect Saved Totals";
    private static final String DUP_TXN = "* Duplicated Transactions";
    private static final String WRONG_ACC_GV_TXN = "* Account's Gift Voucher Txn Different Day";
    private static final String WRONG_GV_TXN_ACC = "* Gift Voucher Txn's Account Different Day";
    private static final Price ANOMALY_CHECK_AMOUNT = new Price(1.0, 0.01);
    private Price runningTotal;
    private final TradingDay theDay;
    private List<RestaurantTakingsSummary> summaries;
    private List<ResultSummary> resultSummaryList;

    public SalesToTakingsReport(TradingDay day) {
        this.theDay = day;
        this.summaries = new ArrayList<RestaurantTakingsSummary>();
        this.resultSummaryList = new ArrayList<ResultSummary>();
        List<Shift> shifts = PersistenceManager.getObjectList(Shift.class, Query.select(Shift.class).equals(Shift.Properties.TRADING_DAY, day).orderBy(Shift.Properties.ID).toString());
        for (Shift shift : shifts) {
            RestaurantTakingsSummary summary = RestaurantTakingsSummary.getSummary(shift);
            this.summaries.add(summary);
            summary.getCalculateTask().run();
        }
    }

    public void doDocket() throws IOException {
        DocketProcessor.printSimpleDocket(this.getDocketString());
    }

    public String getDocketString() {
        StringBuilder SB = new StringBuilder();
        if (this.summaries.size() > 1) {
            for (RestaurantTakingsSummary summary : this.summaries) {
                SB.append("Shift\t").append(summary.getShift()).append("\r\n");
                this.doForSummary(summary, SB);
                SB.append("\r\n\r\n");
            }
        }
        SB.append("Trading Day\t").append(this.theDay).append("\r\n");
        this.doForSummary(null, SB);
        return SB.toString();
    }

    private ValueHolder getSalesRoundingAmount(RestaurantTakingsSummary summary) {
        Price tally = Price.ZERO_DOLLAR;
        if (summary == null) {
            for (RestaurantTakingsSummary nextSummary : this.summaries) {
                tally = tally.add(nextSummary.getAccountsTotal());
                tally = tally.add(this.getTotalVoucherTopups((RestaurantTakingsSummary)nextSummary).amount);
                tally = tally.subtract(nextSummary.getTotalVoucherTopupReversals());
            }
            Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getTotalSalesByAccountQry(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.TRADING_DAY), new Object[]{this.theDay.getID()});
            tally = tally.subtract(new Price((Double)result[0][0], 0.01));
        } else {
            Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(RestaurantTakingsSummaryQueryHelper.getTotalSalesByAccountQry(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.SHIFT), new Object[]{summary.getShift().getID()});
            tally = summary.getAccountsTotal().subtract(new Price((Double)result[0][0], 0.01));
            tally = tally.add(summary.getTotalVoucherTopups());
        }
        if (tally.abs().greaterThan(new Price(1.0, 0.01))) {
            return new ValueHolder("Unaccounted Difference", tally);
        }
        return new ValueHolder("Sales Rounding Adjustment", tally);
    }

    private void doForSummary(RestaurantTakingsSummary summary, StringBuilder SB) {
        ExperimentalFeature OldPaymentsFeature;
        ExperimentalFeature feature;
        this.runningTotal = Price.ZERO_DOLLAR;
        this.getSales(summary, SB);
        this.add(this.getSalesIncDiscountsAndRefunds(summary), SB);
        this.subtract(this.getRefundsFromPreviousDays(summary), SB);
        this.subtract(this.getAppliedPreviousTransactionsFromDebtors(summary), SB);
        this.subtract(this.getNettDebtorSales(summary), SB);
        this.add(this.getNettDebtorPayments(summary), SB);
        this.subtractIfNotZero(this.getDebtorAdjustments(summary), SB);
        this.add(this.getTotalVoucherTopups(summary), SB);
        this.subtract(this.getTotalVoucherTopupsDifferentDay(summary), SB);
        this.subtractIfNotZero(this.getTotalVoucherTopupReversals(summary), SB);
        this.subtract(this.getTotalVoucherRedeems(summary), SB);
        this.add(this.getTotalVoucherRedeemsDifferentDay(summary), SB);
        this.addIfNotZero(this.getTotalVoucherRedeemReversals(summary), SB);
        ValueHolder todayOpenAccounts = this.getTodaysOpenAccounts(summary);
        this.subtractIfNotZero(todayOpenAccounts, SB);
        if (!todayOpenAccounts.amount.equals(Price.ZERO_DOLLAR)) {
            this.add(this.getAmountPaidInTodaysOpenAccounts(summary), SB);
        }
        if ((feature = ExperimentalFeature.find("Allow Sales Allocated To Previous")) == null || feature.getBooleanValue(true).booleanValue()) {
            this.addIfNotZero(this.getSalesAllocatedToPrevious(summary), SB);
        }
        if ((OldPaymentsFeature = ExperimentalFeature.find("Experimental Previous Trading Day Payment Query")) != null && OldPaymentsFeature.getBooleanValue(false).booleanValue()) {
            this.addIfNotZero(this.getPaymentsToAccountsFromPreviousTradingDays_Experimental(summary), SB);
        } else {
            this.addIfNotZero(this.getPaymentsToAccountsFromPreviousTradingDays(summary), SB);
        }
        ValueHolder salesFromFuture = this.getSalesFromFuture(summary);
        this.subtractIfNotZero(salesFromFuture, SB);
        ValueHolder AccountsOpenSincePaid = this.getTablesOpenSincePaid(summary);
        this.subtractIfNotZero(AccountsOpenSincePaid, SB);
        if (!AccountsOpenSincePaid.amount.equals(Price.ZERO_DOLLAR)) {
            this.add(this.getTablesAmountOwedOpenSincePaid(summary), SB);
        }
        ValueHolder futureDebtorPayment = this.getFutureDebtorPaid(summary);
        this.subtractIfNotZero(futureDebtorPayment, SB);
        this.addIfNotZero(this.getPastSalesPaidToDebtor(summary), SB);
        this.subtractIfNotZero(this.getPaymentsFromThePast(summary), SB);
        this.addIfNotZero(this.getPaymentsToTheFuture(summary), SB);
        Price takings = this.getTakings(summary, SB);
        Price takingsDifference = this.runningTotal.subtract(takings).abs();
        if (takingsDifference.abs().greaterThan(ANOMALY_CHECK_AMOUNT)) {
            this.addIfNotZero(this.getSalesToPastExcess(summary), SB);
            this.subtractIfNotZero(this.getSalesFromFutureExcess(summary), SB);
        }
        ValueHolder roundingAmt = this.getSalesRoundingAmount(summary);
        if (summary == null && roundingAmt.amount.abs().greaterThan(ANOMALY_CHECK_AMOUNT)) {
            Price anomalyPrice = this.runPreRoundingAnomalyCheck(SB);
            roundingAmt.amount = roundingAmt.amount.add(anomalyPrice);
        }
        this.subtractIfNotZero(roundingAmt, SB);
        if (summary == null && takingsDifference.greaterThan(ANOMALY_CHECK_AMOUNT)) {
            Price price = this.runAnomalyCheck(SB);
        }
        SB.append("Takings: ").append(takings);
        this.resultSummaryList.add(new ResultSummary(summary != null ? summary.getShift().toString() : this.theDay.toString(), this.runningTotal, takings, roundingAmt.amount));
    }

    private ValueHolder getSalesAllocatedToPrevious(RestaurantTakingsSummary summary) {
        if (summary == null) {
            return new ValueHolder("Sales Made During this Day to Stale Accounts", RestaurantTakingsSummaryQueryHelper.getPreviousSalesForAccountsByTradingDay(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.TRADING_DAY, this.theDay.getID()));
        }
        return new ValueHolder("Sales Made During this Shift to Stale Accounts", this.extract("getPreviousShiftSaleForAccountsInShift", summary));
    }

    private ValueHolder getSalesFromFuture(RestaurantTakingsSummary summary) {
        if (summary == null) {
            return new ValueHolder("Sales Added During a Future Day to Accounts that were Opened During this Day", RestaurantTakingsSummaryQueryHelper.getFutureSalesForAccountsByTradingDay(this.theDay.getID()));
        }
        return new ValueHolder("Sales Added During a Future Shift to Accounts that were Opened During this Shift", this.extract("getFutureShiftSalesForAccountsInShift", summary));
    }

    private ValueHolder getSalesFromFutureExcess(RestaurantTakingsSummary summary) {
        String query = summary == null ? "select sum(amount_paid) from finance_transaction inner join sales_account on finance_transaction.fk_payoff_account = sales_account.id where sales_account.fk_finance_trading_day = " + this.theDay.getID() + " and finance_transaction.fk_finance_trading_day >  " + this.theDay.getID() : "select sum(amount_paid) from finance_transaction inner join sales_account on finance_transaction.fk_payoff_account = sales_account.id where sales_account.fk_finance_shift = " + summary.getShift().getID() + " and finance_transaction.fk_finance_shift >  " + summary.getShift().getID();
        Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query, null);
        double totalInbalance = 0.0;
        for (Object[] sTotal : savedTotals) {
            if (sTotal[0] == null) continue;
            totalInbalance += ((Number)sTotal[0]).doubleValue();
        }
        Price total = new Price(totalInbalance, 0.01);
        total = total.subtract(this.getTotalVoucherTopupsDifferentDay((RestaurantTakingsSummary)summary).amount);
        total = total.subtract(this.getSalesFromFuture((RestaurantTakingsSummary)summary).amount);
        total = total.subtract(this.getTablesOpenSincePaid((RestaurantTakingsSummary)summary).amount);
        total = total.subtract(this.getFutureDeletions().amount.negate());
        return new ValueHolder("* Unaccounted Payments or Refunds Made During a Future " + this.getFilterByDescription(summary) + " to Accounts that were Opened During this " + this.getFilterByDescription(summary), total);
    }

    private ValueHolder getSalesToPastExcess(RestaurantTakingsSummary summary) {
        String query = summary == null ? "select sum(amount_paid) from finance_transaction inner join sales_account on finance_transaction.fk_payoff_account = sales_account.id where sales_account.fk_finance_trading_day < " + this.theDay.getID() + " and finance_transaction.fk_finance_trading_day =  " + this.theDay.getID() : "select sum(amount_paid) from finance_transaction inner join sales_account on finance_transaction.fk_payoff_account = sales_account.id where sales_account.fk_finance_shift < " + summary.getShift().getID() + " and finance_transaction.fk_finance_shift =  " + summary.getShift().getID();
        Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query, null);
        double totalInbalance = 0.0;
        for (Object[] sTotal : savedTotals) {
            if (sTotal[0] == null) continue;
            totalInbalance += ((Number)sTotal[0]).doubleValue();
        }
        Price total = new Price(totalInbalance, 0.01);
        total = total.subtract(this.extract("getCostOfRefundsFromPreviousShifts", summary).negate());
        total = total.subtract(this.getPaymentsToAccountsFromPreviousTradingDays((RestaurantTakingsSummary)summary).amount);
        total = total.subtract(this.getSalesAllocatedToPrevious((RestaurantTakingsSummary)summary).amount);
        total = total.subtract(this.getDeletionsToPast().amount.negate());
        return new ValueHolder("* Unaccounted Payments or Refunds Made During this " + this.getFilterByDescription(summary) + " to Accounts Opened on a Previous " + this.getFilterByDescription(summary), total);
    }

    private ValueHolder getPaymentsFromThePast(RestaurantTakingsSummary summary) {
        return new ValueHolder("Payments Made During a Previous " + this.getFilterByDescription(summary) + " to an Account that was Opened During this " + this.getFilterByDescription(summary), RestaurantTakingsSummaryQueryHelper.getPastPaymentsForAccountsByTradingDay(this.theDay.getID()));
    }

    private ValueHolder getPaymentsToTheFuture(RestaurantTakingsSummary summary) {
        return new ValueHolder("Payments Made During this " + this.getFilterByDescription(summary) + " to an Account that was Opened in a Future " + this.getFilterByDescription(summary), RestaurantTakingsSummaryQueryHelper.getFuturePaymentsForAccountsByTradingDay(this.theDay.getID()));
    }

    private void add(ValueHolder holder, StringBuilder SB) {
        this.runningTotal = this.runningTotal.add(holder.amount);
        SB.append("+ \t").append(holder.title).append("\t ").append(holder.amount).append("\t ").append(this.runningTotal).append("\r\n");
    }

    private void addIfNotZero(ValueHolder holder, StringBuilder SB) {
        if (holder.amount.equals(Price.ZERO_DOLLAR)) {
            return;
        }
        this.runningTotal = this.runningTotal.add(holder.amount);
        SB.append("+ \t").append(holder.title).append("\t ").append(holder.amount).append("\t ").append(this.runningTotal).append("\r\n");
    }

    private void subtract(ValueHolder holder, StringBuilder SB) {
        this.runningTotal = this.runningTotal.subtract(holder.amount);
        SB.append("- \t").append(holder.title).append("\t ").append(holder.amount).append("\t ").append(this.runningTotal).append("\r\n");
    }

    private void subtractIfNotZero(ValueHolder holder, StringBuilder SB) {
        if (holder.amount.equals(Price.ZERO_DOLLAR)) {
            return;
        }
        this.runningTotal = this.runningTotal.subtract(holder.amount);
        SB.append("- \t").append(holder.title).append("\t ").append(holder.amount).append("\t ").append(this.runningTotal).append("\r\n");
    }

    private void getSales(RestaurantTakingsSummary summary, StringBuilder SB) {
        SB.append("Sales: ").append(this.extract("getAccountsTotal", summary)).append("\r\n");
    }

    private Price getTakings(RestaurantTakingsSummary summary, StringBuilder SB) {
        Price totalTakings = this.extract("getTotalTakings", summary);
        return totalTakings;
    }

    private ValueHolder getSalesIncDiscountsAndRefunds(RestaurantTakingsSummary summary) {
        return new ValueHolder("Sales", this.extract("getAccountsTotal", summary));
    }

    private ValueHolder getRefundsFromPreviousDays(RestaurantTakingsSummary summary) {
        return new ValueHolder("Refunds Made During this " + this.getFilterByDescription(summary) + " to Accounts Opened on a Previous " + this.getFilterByDescription(summary), this.extract("getCostOfRefundsFromPreviousShifts", summary));
    }

    private ValueHolder getPaymentsToAccountsFromPreviousTradingDays(RestaurantTakingsSummary summary) {
        Price tally = Price.ZERO_DOLLAR;
        tally = summary == null ? tally.add(RestaurantTakingsSummaryQueryHelper.getPaidPreviousForExcessAmountFromToday(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.TRADING_DAY, this.theDay.getID())) : tally.add(RestaurantTakingsSummaryQueryHelper.getPaidPreviousForExcessAmountFromToday(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.SHIFT, summary.getShift().getID()));
        return new ValueHolder("Payments Made During this " + this.getFilterByDescription(summary) + " to Stale Accounts", tally);
    }

    private ValueHolder getPaymentsToAccountsFromPreviousTradingDays_Experimental(RestaurantTakingsSummary summary) {
        String query = summary == null ? Query.sum(FinanceTransaction.Properties.PAID, "value").active(FinanceTransaction.class).linkUsing(FinanceTransaction.Properties.ACCOUNT).equals(FinanceTransaction.Properties.TRADING_DAY, this.theDay.getID()).not().equals(Account.Properties.TRADING_DAY, this.theDay.getID()).toString() : Query.sum(FinanceTransaction.Properties.PAID, "value").active(FinanceTransaction.class).linkUsing(FinanceTransaction.Properties.ACCOUNT).equals(FinanceTransaction.Properties.SHIFT, summary.getShift().getID()).not().equals(Account.Properties.SHIFT, summary.getShift().getID()).toString();
        Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query, null);
        double totalInbalance = 0.0;
        for (Object[] sTotal : savedTotals) {
            if (sTotal[0] == null) continue;
            totalInbalance += ((Number)sTotal[0]).doubleValue();
        }
        return new ValueHolder("Payments Made During this " + this.getFilterByDescription(summary) + " to Stale Accounts", new Price(totalInbalance, 0.01));
    }

    private ValueHolder getNettDebtorSales(RestaurantTakingsSummary summary) {
        return new ValueHolder("Sales Added to Debtors", this.extract("getTotalNettDebtorsAdded", summary));
    }

    private ValueHolder getNettDebtorPayments(RestaurantTakingsSummary summary) {
        return new ValueHolder("Payments Made to Debtors", this.extract("getTotalNettDebtorsPaid", summary));
    }

    private ValueHolder getDebtorAdjustments(RestaurantTakingsSummary summary) {
        return new ValueHolder("Adjustments Made to Debtors", this.extract("getTotalDebtorsAdjustments", summary));
    }

    private ValueHolder getTotalVoucherTopups(RestaurantTakingsSummary summary) {
        ObjectQuery query = summary == null ? Query.sum(GiftVoucherTransaction.Properties.AMOUNT, "price").active(GiftVoucherTransaction.class).linkUsing(GiftVoucherTransaction.Properties.ACCOUNT).equals(Account.Properties.TRADING_DAY, this.theDay.getID()).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).groupBy(GiftVoucherTransaction.Properties.TRADING_DAY).greaterThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION) : Query.sum(GiftVoucherTransaction.Properties.AMOUNT, "price").active(GiftVoucherTransaction.class).linkUsing(GiftVoucherTransaction.Properties.ACCOUNT).equals(Account.Properties.SHIFT, summary.getShift().getID()).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).groupBy(GiftVoucherTransaction.Properties.SHIFT).greaterThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null);
        double totalInbalance = 0.0;
        for (Object[] sTotal : savedTotals) {
            if (sTotal[0] == null) continue;
            totalInbalance += ((Number)sTotal[0]).doubleValue();
        }
        return new ValueHolder("Voucher Topups", new Price(totalInbalance, 0.01));
    }

    private ValueHolder getTotalVoucherTopupsDifferentDay(RestaurantTakingsSummary summary) {
        ObjectQuery query = summary == null ? Query.sum(GiftVoucherTransaction.Properties.AMOUNT, "price").active(GiftVoucherTransaction.class).linkUsing(GiftVoucherTransaction.Properties.ACCOUNT).equals(Account.Properties.TRADING_DAY, this.theDay.getID()).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).not().equals(GiftVoucherTransaction.Properties.TRADING_DAY, this.theDay.getID()).groupBy(GiftVoucherTransaction.Properties.TRADING_DAY).greaterThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION) : Query.sum(GiftVoucherTransaction.Properties.AMOUNT, "price").active(GiftVoucherTransaction.class).linkUsing(GiftVoucherTransaction.Properties.ACCOUNT).equals(Account.Properties.SHIFT, summary.getShift().getID()).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).not().equals(GiftVoucherTransaction.Properties.SHIFT, summary.getShift().getID()).groupBy(GiftVoucherTransaction.Properties.SHIFT).greaterThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null);
        double totalInbalance = 0.0;
        for (Object[] sTotal : savedTotals) {
            if (sTotal[0] == null) continue;
            totalInbalance += ((Number)sTotal[0]).doubleValue();
        }
        return new ValueHolder("Voucher Topups From a Different " + this.getFilterByDescription(summary), new Price(totalInbalance, 0.01));
    }

    private ValueHolder getTotalVoucherRedeems(RestaurantTakingsSummary summary) {
        ObjectQuery query = summary == null ? Query.sum(GiftVoucherTransaction.Properties.AMOUNT, "price").active(GiftVoucherTransaction.class).linkUsing(GiftVoucherTransaction.Properties.ACCOUNT).equals(Account.Properties.TRADING_DAY, this.theDay.getID()).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).groupBy(GiftVoucherTransaction.Properties.TRADING_DAY).lessThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION) : Query.sum(GiftVoucherTransaction.Properties.AMOUNT, "price").active(GiftVoucherTransaction.class).linkUsing(GiftVoucherTransaction.Properties.ACCOUNT).equals(Account.Properties.SHIFT, summary.getShift().getID()).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).groupBy(GiftVoucherTransaction.Properties.SHIFT).lessThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null);
        double totalInbalance = 0.0;
        for (Object[] sTotal : savedTotals) {
            if (sTotal[0] == null) continue;
            totalInbalance -= ((Number)sTotal[0]).doubleValue();
        }
        return new ValueHolder("Voucher Redeems", new Price(totalInbalance, 0.01));
    }

    private ValueHolder getTotalVoucherRedeemsDifferentDay(RestaurantTakingsSummary summary) {
        ObjectQuery query = summary == null ? Query.sum(GiftVoucherTransaction.Properties.AMOUNT, "price").active(GiftVoucherTransaction.class).linkUsing(GiftVoucherTransaction.Properties.ACCOUNT).equals(Account.Properties.TRADING_DAY, this.theDay.getID()).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).not().equals(GiftVoucherTransaction.Properties.TRADING_DAY, this.theDay.getID()).groupBy(GiftVoucherTransaction.Properties.TRADING_DAY).lessThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION) : Query.sum(GiftVoucherTransaction.Properties.AMOUNT, "price").active(GiftVoucherTransaction.class).linkUsing(GiftVoucherTransaction.Properties.ACCOUNT).equals(Account.Properties.SHIFT, summary.getShift().getID()).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).not().equals(GiftVoucherTransaction.Properties.SHIFT, summary.getShift().getID()).groupBy(GiftVoucherTransaction.Properties.SHIFT).lessThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null);
        double totalInbalance = 0.0;
        for (Object[] sTotal : savedTotals) {
            if (sTotal[0] == null) continue;
            totalInbalance += ((Number)sTotal[0]).doubleValue();
        }
        return new ValueHolder("Voucher Reedems From Different Trading Days", new Price(totalInbalance, 0.01));
    }

    private ValueHolder getTotalVoucherTopupReversals(RestaurantTakingsSummary summary) {
        return new ValueHolder("Voucher Topup Reversals", this.extract("getTotalVoucherTopupReversals", summary));
    }

    private ValueHolder getTotalVoucherRedeemReversals(RestaurantTakingsSummary summary) {
        return new ValueHolder("Voucher Redeem Reversals", this.extract("getTotalVoucherRedeemReversals", summary));
    }

    private ValueHolder getAppliedPreviousTransactionsFromDebtors(RestaurantTakingsSummary summary) {
        return new ValueHolder("Payments Moved from Debtors to Accounts", this.extract("getAppliedPreviousTransactions", summary));
    }

    private ValueHolder getAmountPaidInTodaysOpenAccounts(RestaurantTakingsSummary summary) {
        Price amount_paid = Price.ZERO_DOLLAR;
        if (summary == null) {
            for (RestaurantTakingsSummary nextSummary : this.summaries) {
                String query = "SELECT SUM(finance_transaction.amount_paid) as price FROM finance_transaction, sales_account WHERE finance_transaction.FK_payoff_account = sales_account.ID AND sales_account.FK_finance_trading_day = " + this.theDay.getID().toString() + " AND finance_transaction.FK_finance_trading_day >= " + this.theDay.getID().toString() + " AND finance_transaction.system_state != 'DELETED' AND sales_account.account_state = 'OPEN'";
                Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query, null);
                double totalInbalance = 0.0;
                for (Object[] sTotal : savedTotals) {
                    if (sTotal[0] == null) continue;
                    totalInbalance += ((Number)sTotal[0]).doubleValue();
                }
                amount_paid = new Price(totalInbalance, 0.01);
            }
        } else {
            String query = "SELECT SUM(finance_transaction.amount_paid) as price FROM finance_transaction, sales_account WHERE finance_transaction.FK_payoff_account = sales_account.ID AND sales_account.FK_finance_shift = " + summary.getShift().getID().toString() + " AND finance_transaction.FK_finance_shift >= " + summary.getShift().getID().toString() + " AND finance_transaction.system_state != 'DELETED' AND sales_account.account_state = 'OPEN'";
            Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query, null);
            double totalInbalance = 0.0;
            for (Object[] sTotal : savedTotals) {
                if (sTotal[0] == null) continue;
                totalInbalance += ((Number)sTotal[0]).doubleValue();
            }
            amount_paid = new Price(totalInbalance, 0.01);
        }
        return new ValueHolder("Amount Paid From this " + this.getFilterByDescription(summary) + "'s Open Accounts", amount_paid);
    }

    private ValueHolder getTodaysOpenAccounts(RestaurantTakingsSummary summary) {
        Price tally = Price.ZERO_DOLLAR;
        if (summary == null) {
            for (RestaurantTakingsSummary nextSummary : this.summaries) {
                tally = tally.add(nextSummary.getAccountsTotal(true));
            }
        } else {
            tally = summary.getAccountsTotal(true);
        }
        return new ValueHolder("Accounts Opened During this " + this.getFilterByDescription(summary) + " that are Still Currently Open", tally);
    }

    private ValueHolder getTablesOpenSincePaid(RestaurantTakingsSummary summary) {
        Price result = Price.ZERO_DOLLAR;
        result = summary == null ? RestaurantTakingsSummaryQueryHelper.getOpenSalesThatNotBeenPaidToday(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.TRADING_DAY, this.theDay.getID()) : RestaurantTakingsSummaryQueryHelper.getOpenSalesThatNotBeenPaidToday(RestaurantTakingsSummaryQueryHelper.PeriodFilterBy.SHIFT, summary.getShift().getID());
        return new ValueHolder("Stale Accounts From This " + this.getFilterByDescription(summary) + " That Have Since Been Paid", result);
    }

    private ValueHolder getTablesAmountOwedOpenSincePaid(RestaurantTakingsSummary summary) {
        Price amount_owed = Price.ZERO_DOLLAR;
        if (summary == null) {
            for (RestaurantTakingsSummary nextSummary : this.summaries) {
                String query = "SELECT saved_total - sum(amount_paid) as price FROM finance_transaction, sales_account WHERE finance_transaction.FK_payoff_account = sales_account.ID AND sales_account.FK_finance_trading_day = " + this.theDay.getID().toString() + " AND finance_transaction.FK_finance_trading_day >= " + this.theDay.getID().toString() + " AND finance_transaction.system_state != 'DELETED' AND sales_account.account_state = 'OPEN'";
                Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query, null);
                double totalInbalance = 0.0;
                for (Object[] sTotal : savedTotals) {
                    if (sTotal[0] == null) continue;
                    totalInbalance += ((Number)sTotal[0]).doubleValue();
                }
                amount_owed = new Price(totalInbalance, 0.01);
            }
        } else {
            String query = "SELECT saved_total - sum(amount_paid) as price FROM finance_transaction, sales_account WHERE finance_transaction.FK_payoff_account = sales_account.ID AND sales_account.FK_finance_shift = " + summary.getShift().getID().toString() + " AND finance_transaction.FK_finance_shift >= " + summary.getShift().getID().toString() + " AND finance_transaction.system_state != 'DELETED' AND sales_account.account_state = 'OPEN'";
            Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query, null);
            double totalInbalance = 0.0;
            for (Object[] sTotal : savedTotals) {
                if (sTotal[0] == null) continue;
                totalInbalance += ((Number)sTotal[0]).doubleValue();
            }
            amount_owed = new Price(totalInbalance, 0.01);
        }
        return new ValueHolder("Amount Still Owed On Stale Accounts From This " + this.getFilterByDescription(summary), amount_owed);
    }

    private String getFilterByDescription(RestaurantTakingsSummary summary) {
        return summary == null ? "Day" : "Shift";
    }

    private Price extract(String methodName, RestaurantTakingsSummary summary) {
        Price tally = Price.ZERO_DOLLAR;
        try {
            Method method = RestaurantTakingsSummary.class.getMethod(methodName, new Class[0]);
            if (summary == null) {
                for (RestaurantTakingsSummary nextSummary : this.summaries) {
                    tally = tally.add((Price)method.invoke((Object)nextSummary, new Object[0]));
                }
            } else {
                tally = (Price)method.invoke((Object)summary, new Object[0]);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot perform Sanity Report.", (Throwable)ex);
        }
        return tally;
    }

    private Price runPreRoundingAnomalyCheck(StringBuilder SB) {
        Price anomalyPrice = Price.ZERO_DOLLAR;
        ValueHolder result = this.getOrphanedTransactions();
        result = this.getIncorrectSavedTotals();
        if (result.amount.abs().greaterThan(Price.ZERO_DOLLAR)) {
            anomalyPrice = anomalyPrice.subtract(result.amount);
            this.subtract(result, SB);
        }
        return anomalyPrice;
    }

    private Price runAnomalyCheck(StringBuilder SB) {
        Price anomalyPrice = Price.ZERO_DOLLAR;
        ValueHolder result = this.getOrphanedTransactions();
        if (result.amount.greaterThan(Price.ZERO_DOLLAR) || result.amount.lessThan(Price.ZERO_DOLLAR)) {
            anomalyPrice = anomalyPrice.add(result.amount);
            this.add(result, SB);
        }
        result = this.getFutureDeletions();
        if (result.amount.lessThan(Price.ZERO_DOLLAR)) {
            result.amount = result.amount.negate();
            anomalyPrice = anomalyPrice.subtract(result.amount);
            this.subtract(result, SB);
        }
        result = this.getDeletionsToPast();
        if (result.amount.lessThan(Price.ZERO_DOLLAR)) {
            result.amount = result.amount.negate();
            anomalyPrice = anomalyPrice.subtract(result.amount);
            this.add(result, SB);
        }
        result = this.getUnbalancedAccounts();
        if (result.amount.abs().greaterThan(Price.ZERO_DOLLAR)) {
            anomalyPrice = anomalyPrice.subtract(result.amount);
            this.subtract(result, SB);
        }
        return anomalyPrice;
    }

    private ValueHolder getOrphanedTransactions() {
        ObjectQuery query = Query.sum(FinanceTransaction.Properties.PAID).isNull(FinanceTransaction.Properties.ACCOUNT).active(FinanceTransaction.class).joinLeft(DebtorPayment.class, DebtorPayment.Properties.FINANCE_TRANSACTION).isNull(DebtorPayment.Properties.ID).equals(FinanceTransaction.Properties.TRADING_DAY, this.theDay);
        return this.doDirectQuery(query.toString(), ORPHAN_TXN);
    }

    private ValueHolder getAccountPaidTodayVoucherTxnWrong() {
        ObjectQuery query = Query.sum(GiftVoucherTransaction.Properties.AMOUNT).equals(GiftVoucherTransaction.Properties.SYSTEM_STATE, "ACTIVE").joinLeft(Account.class, GiftVoucherTransaction.Properties.ACCOUNT).not().equals(GiftVoucherTransaction.Properties.TRADING_DAY, this.theDay).equals(Account.Properties.TRADING_DAY, this.theDay);
        ValueHolder holder = this.doDirectQuery(query.toString(), WRONG_ACC_GV_TXN);
        return holder;
    }

    private ValueHolder getVoucherTxnPaidTodayAccountWrong() {
        ObjectQuery query = Query.sum(GiftVoucherTransaction.Properties.AMOUNT).equals(GiftVoucherTransaction.Properties.SYSTEM_STATE, "ACTIVE").joinLeft(Account.class, GiftVoucherTransaction.Properties.ACCOUNT).equals(GiftVoucherTransaction.Properties.TRADING_DAY, this.theDay).not().equals(Account.Properties.TRADING_DAY, this.theDay);
        return this.doDirectQuery(query.toString(), WRONG_GV_TXN_ACC);
    }

    private ValueHolder getTransactionsIncorrectTradingDay(RestaurantTakingsSummary summary) {
        double totalInbalance = 0.0;
        if (summary == null) {
            Object[][] savedTotals;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String DATE_TRADING = df.format(this.theDay.getDate());
            String query = "SELECT saved_total, sales_account.id FROM sales_account left join finance_trading_day on finance_trading_day.ID = sales_account.FK_finance_trading_day where sales_account.creation_time like '%" + DATE_TRADING + "%' and sales_account.creation_time NOT BETWEEN CAST(finance_trading_day.day as DATETIME) + CAST(finance_trading_day.time as TIME) AND CAST(finance_trading_day.close_day as DATETIME) + CAST(finance_trading_day.close_time as TIME)";
            for (Object[] sTotal : savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query, null)) {
                Object[][] savedTotalsNew;
                double totalBalanceForId = ((Number)sTotal[0]).doubleValue();
                String queryNew = "SELECT sum(finance_transaction.amount_paid) as total FROM finance_transaction left join sales_account on sales_account.id = finance_transaction.FK_payoff_account left join finance_trading_day on finance_trading_day.ID = sales_account.FK_finance_trading_day where sales_account.id = " + ((Number)sTotal[1]).toString() + " AND finance_transaction.timestamp like '%" + DATE_TRADING + "%'GROUP by finance_transaction.FK_payoff_account";
                for (Object[] sTotalNew : savedTotalsNew = PersistenceManager.getPersistenceDelegate().executeQuery(queryNew, null)) {
                    totalBalanceForId -= ((Number)sTotalNew[0]).doubleValue();
                }
                totalInbalance += totalBalanceForId;
            }
        }
        return new ValueHolder("* Incorrect Trading Day Unpaid Amount", new Price(totalInbalance, 0.01));
    }

    private ValueHolder getFutureDeletions() {
        ObjectQuery query = Query.sumMultiplication(SalesItemQuantity.Properties.QUANTITY, SalesComponent.Properties.SAVED_UNIT_PRICE).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).whereIn("item_state", Arrays.asList("DELETED", "DELETED_WASTED", "MOVED")).equals(Account.Properties.TRADING_DAY, this.theDay).not().equals(SalesItemQuantity.Properties.TRADING_DAY, this.theDay);
        return this.doDirectQuery(query.toString(), FUTURE_DELETIONS);
    }

    private ValueHolder getDeletionsToPast() {
        ObjectQuery query = Query.sumMultiplication(SalesItemQuantity.Properties.QUANTITY, SalesComponent.Properties.SAVED_UNIT_PRICE).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).whereIn("item_state", Arrays.asList("DELETED", "DELETED_WASTED", "MOVED")).not().equals(Account.Properties.TRADING_DAY, this.theDay).equals(SalesItemQuantity.Properties.TRADING_DAY, this.theDay);
        return this.doDirectQuery(query.toString(), "* Sales Deleted From The Past");
    }

    private ValueHolder getUnbalancedAccounts() {
        String query = "SELECT saved_total - sum(if(txn.id is null, 0, amount_paid)) total FROM sales_account acc LEFT JOIN finance_transaction txn on txn.fk_payoff_account = acc.id WHERE acc.FK_finance_trading_day = " + this.theDay.getID().toString() + " AND account_state = 'CLOSED'  AND (txn.system_state = 'ACTIVE' OR txn.id is null)  AND acc.id NOT IN (SELECT fk_sales_account from debtor_sale ds WHERE ds.FK_finance_shift >= acc.FK_finance_shift) GROUP BY acc.id HAVING abs(total) > 0.01 ";
        Object[][] savedTotals = PersistenceManager.getPersistenceDelegate().executeQuery(query, null);
        double totalInbalance = 0.0;
        for (Object[] sTotal : savedTotals) {
            totalInbalance += ((Number)sTotal[0]).doubleValue();
        }
        return new ValueHolder(UNBALANCED_ACCOUNTS, new Price(totalInbalance, 0.01));
    }

    private ValueHolder getFutureDebtorPaid(RestaurantTakingsSummary summary) {
        String query = "SELECT sum(sc.unit_price * siq.quantity) FROM debtor_sale          JOIN sales_account acc on acc.id = debtor_sale.fk_sales_account          JOIN sales_item si on si.fk_sales_account=acc.id          JOIN sales_item_quantity siq on siq.fk_sales_item=si.id          JOIN sales_component sc on sc.fk_sales_item=si.id ";
        if (summary == null) {
            query = query + " JOIN finance_shift fs on debtor_sale.fk_finance_shift=fs.id ";
            query = query + " WHERE siq.fk_finance_trading_day = " + this.theDay.getID().toString();
            query = query + "  AND fs.FK_finance_trading_day <> " + this.theDay.getID().toString();
        } else {
            query = query + "WHERE siq.FK_finance_shift = " + summary.getShift().getID() + " AND debtor_sale.FK_finance_shift <> " + summary.getShift().getID();
        }
        return this.doDirectQuery(query, "Stale Accounts From This " + this.getFilterByDescription(summary) + " That Have Since Been Added To Debtors");
    }

    private ValueHolder getPastSalesPaidToDebtor(RestaurantTakingsSummary summary) {
        String query = "SELECT sum(acc.saved_total) total FROM sales_account acc JOIN debtor_sale on debtor_sale.fk_sales_account = acc.id ";
        query = summary == null ? query + "JOIN finance_shift fshift on fshift.id = debtor_sale.fk_finance_shift WHERE acc.FK_finance_trading_day <> " + this.theDay.getID().toString() + " AND fshift.FK_finance_trading_day = " + this.theDay.getID().toString() : query + "WHERE acc.FK_finance_shift <> " + summary.getShift().getID() + " AND debtor_sale.FK_finance_shift = " + summary.getShift().getID();
        return this.doDirectQuery(query, "Stale Accounts From a Previous " + this.getFilterByDescription(summary) + " Added to Debtors During this " + this.getFilterByDescription(summary));
    }

    private ValueHolder getIncorrectSavedTotals() {
        String query = "SELECT ifnull(sc_total,0) - sum(sa.saved_total) + ifnull(gv_total.total,0) as total FROM sales_account sa LEFT JOIN (SELECT sum(sc.unit_price * siq.quantity)  as sc_total FROM sales_item_quantity siq JOIN sales_item si on si.id = siq.fk_sales_item JOIN sales_component sc on sc.fk_sales_item = si.id JOIN sales_account sa on sa.id=si.fk_sales_accountWHERE siq.fk_finance_trading_day = " + this.theDay.getID().toString() + " sa.fk_finance_trading_day = " + this.theDay.getID().toString() + ") sc_total on 1 LEFT JOIN (select sum(amount) as total FROM finance_gift_voucher_transaction fgvt JOIN sales_account sa on sa.id = fk_sales_account WHERE sa.fk_finance_trading_day = " + this.theDay.getID().toString() + " and system_state = 'ACTIVE' and amount > 0) gv_total on 1 WHERE fk_finance_trading_day = " + this.theDay.getID().toString();
        return this.doDirectQuery(query, INCORRECT_TOTALS);
    }

    private ValueHolder doDirectQuery(String query, String name) {
        try {
            Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new Object[0]);
            if (result.length > 0) {
                if (result[0][0] == null) {
                    return new ValueHolder(name, Price.ZERO_DOLLAR);
                }
                return new ValueHolder(name, new Price((Number)result[0][0], 0.01));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot examine " + name, (Throwable)ex);
        }
        return new ValueHolder(name, Price.ZERO_DOLLAR);
    }

    Price getRunningTotal() {
        return this.runningTotal;
    }

    public Price getFinalDifference() {
        return this.getTakings(null, new StringBuilder()).subtract(this.runningTotal);
    }

    List<ResultSummary> getResultSummaryList() {
        return this.resultSummaryList;
    }

    static class ResultSummary {
        private String period;
        private Price runningTotal;
        private Price takings;
        private Price rounding;

        public ResultSummary(String period, Price runningTotal, Price takings, Price rounding) {
            this.period = period;
            this.runningTotal = runningTotal;
            this.takings = takings;
            this.rounding = rounding;
        }

        public String getPeriod() {
            return this.period;
        }

        public Price getRunningTotal() {
            return this.runningTotal;
        }

        public Price getTakings() {
            return this.takings;
        }

        public Price getRounding() {
            return this.rounding;
        }
    }

    static class ValueHolder {
        String title;
        Price amount = Price.ZERO_DOLLAR;

        ValueHolder(String theTitle, Price theAmount) {
            this.title = theTitle;
            this.amount = theAmount == null ? Price.ZERO_DOLLAR : theAmount;
        }
    }
}

