/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.salestotakings;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.salestotakings.SalesToTakingsCompiler;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.OrdermateSmallTextReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.GenericBiListTableModel;
import ordermate.reports.printing.HeaderSubReport;

public class SalesToTakingsReportProvider
extends AbstractReportProvider {
    private final SalesToTakingsCompiler compiler;
    private final Map<String, Style> colToStyleMap;
    private static final String EMPTY_FIELD = "";
    private static final String REPORT_TITLE = "Sales To Takings Report";
    private static final String CATEGORY_COL_NAME = "Category";
    private static final int CATEGORY_COL_WIDTH = 200;

    public SalesToTakingsReportProvider() {
        this(new SalesToTakingsCompiler());
    }

    public SalesToTakingsReportProvider(SalesToTakingsCompiler compiler) {
        this.compiler = compiler;
        this.colToStyleMap = this.createColToStyleMap();
    }

    public SalesToTakingsCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        JRTableModelDataSource dataSource = new JRTableModelDataSource(this.createTableModel());
        return dataSource;
    }

    private TableModel createTableModel() {
        List compilerResults = this.compiler.compile();
        this.padAllResultsForTable(compilerResults);
        return new GenericBiListTableModel(new ArrayList<String>(this.colToStyleMap.keySet()), compilerResults);
    }

    private void padAllResultsForTable(List<List<String>> compilerResults) {
        int numCols = this.colToStyleMap.keySet().size();
        for (List<String> resultStr : compilerResults) {
            for (int i = resultStr.size(); i < numCols; ++i) {
                resultStr.add(EMPTY_FIELD);
            }
        }
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public synchronized ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateMinimalistStyle(), ReportBuilder.TemplateFormat.A4Portrait);
        builder.addBusinessLogoDetailHeaderAndFooterTemplate();
        this.getParameters().putAll(new HeaderSubReport().getParamsMap());
        builder.setTitle(REPORT_TITLE);
        builder.setSubtitle(TradingDayFilteredReportSearcher.DisplayHelper.formatTradingDay(this.compiler.getSearchTradingDay()));
        for (String name : this.colToStyleMap.keySet()) {
            SimpleColumn column = this.makeColumn(name, String.class, this.colToStyleMap.get(name));
            builder.getReportBuilder().addColumn((AbstractColumn)column);
        }
        return builder;
    }

    private SimpleColumn makeColumn(String name, Class clazz, Style style) {
        ColumnProperty prop = new ColumnProperty(name, clazz);
        SimpleColumn column = new SimpleColumn();
        column.setColumnProperty(prop);
        column.setName(name);
        column.setTitle(name);
        if (CATEGORY_COL_NAME.equals(name)) {
            column.setWidth(Integer.valueOf(200));
        }
        column.setStyle(style == null ? new OrdermateSmallTextReportStyle().getColumnDetailStyle() : style);
        return column;
    }

    public void setTradingDay(TradingDay tradingDay) {
        this.compiler.setSearchTradingDay(tradingDay);
    }

    private Map<String, Style> createColToStyleMap() {
        LinkedHashMap<String, Style> tmpColToStyleMap = new LinkedHashMap<String, Style>();
        Style normalStyle = new OrdermateSmallTextReportStyle().getColumnDetailStyle();
        Style rightAligned = new OrdermateSmallTextReportStyle().getColumnDetailStyle();
        rightAligned.setHorizontalAlign(HorizontalAlign.RIGHT);
        tmpColToStyleMap.put("Action", normalStyle);
        tmpColToStyleMap.put(CATEGORY_COL_NAME, normalStyle);
        tmpColToStyleMap.put("Amount", rightAligned);
        tmpColToStyleMap.put("Running Total", rightAligned);
        return tmpColToStyleMap;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

