/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sata.DayReportCompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.SATAReportProperties;

abstract class AbstractSATACompiler
implements DayReportCompiler {
    private Date from;
    private Date to;
    protected boolean siqTradingDay = false;
    protected boolean groupByDayParts = false;
    protected List<SalesLocation> salesLocations = Collections.emptyList();

    @Override
    public void setDays(Date dateFrom, Date dateTo) {
        this.from = dateFrom;
        this.to = dateTo;
    }

    protected Date getFrom() {
        return this.from;
    }

    protected Date getTo() {
        return this.to;
    }

    public void setUseSIQTradingDay(boolean value) {
        this.siqTradingDay = value;
    }

    public void setSalesLocations(List<SalesLocation> locations) {
        this.salesLocations = locations;
        if (this.salesLocations == null) {
            this.salesLocations = Collections.emptyList();
        }
    }

    public void groupByDayParts(boolean value) {
        this.groupByDayParts = value;
    }

    protected TradingDayDateRangeFilterAdapter getTDFilter() {
        OptimisedDateRangeSearchFilter dateRange = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE);
        dateRange.setStart(this.getFrom());
        dateRange.setEnd(this.getTo());
        return new TradingDayDateRangeFilterAdapter(dateRange);
    }

    protected void initPayments(boolean totalEftposPerCD, List<FinanceUnit> units, Map<Long, SATAReport> reportMap) {
        String hiddenColumns = SATAReportProperties.getHiddenColumns();
        for (FinanceUnit fUnit : FinanceUnit.getElectronicUnits()) {
            if (hiddenColumns.contains(fUnit.getLabel())) continue;
            units.add(fUnit);
        }
        for (FinanceUnit fUnit : FinanceUnit.getWebUnits()) {
            if (hiddenColumns.contains(fUnit.getLabel())) continue;
            units.add(fUnit);
        }
        if (totalEftposPerCD) {
            for (FinanceUnit.EftposUnitType type : FinanceUnit.EftposUnitType.values()) {
                FinanceUnit fUnit = FinanceUnit.getUnitForName(type.getUnitName());
                if (!units.contains(fUnit)) continue;
                units.remove(fUnit);
            }
        }
        for (FinanceUnit unit : units) {
            for (SATAReport report : reportMap.values()) {
                report.getFinancePayments().add(new Pair<String, Price>(unit.getLabel(), Price.ZERO_NO_ROUND));
            }
        }
    }
}

