/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import java.util.Map;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.CoversReport;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.sales.Account;

public class CoversCompiler
extends AbstractSATACompiler {
    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        ObjectQuery query = Query.select(TradingDay.Properties.ID, "fk_finance_trading_day").selectFunc("0 as total_sales").selectFunc("'TABLE' as account_type").selectFunc("'' as section").linkUsing(Account.Properties.TRADING_DAY).groupBy(Account.Properties.TRADING_DAY);
        this.getTDFilter().addQueryRestriction(query);
        query.selectFunc("SUM(sales_account.patrons) as total_covers");
        if (!this.salesLocations.isEmpty()) {
            query.whereIn("sales_account.fk_config_sales_location", this.salesLocations);
        }
        if (this.groupByDayParts) {
            query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("sales_account.creation_time"));
            query.groupBy("fk_config_day_part");
        } else {
            query.selectFunc("null as fk_config_day_part");
        }
        List<CoversReport> coversReports = PersistenceManager.getObjectList(CoversReport.class, query.toString());
        for (CoversReport coversReport : coversReports) {
            SATAReport sataRep = reportMap.get(SATAReport.createId(coversReport.getTradingDay(), coversReport.getDayPart()));
            sataRep.setCovers(sataRep.getCovers() + coversReport.getCovers());
        }
    }
}

