/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.util.List;
import java.util.Map;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.reports.general.PriceReport;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.sales.SalesItemQuantity;

public class DebtorCompiler
extends AbstractSATACompiler {
    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        this.populateDebtorPayments(reportMap);
        this.populateDebtorSales(reportMap);
    }

    private void populateDebtorPayments(Map<Long, SATAReport> reportMap) {
        FinanceUnit accountSubType = PersistenceManager.getObject(FinanceUnit.class, Query.select(FinanceUnit.class).equals(FinanceUnit.Properties.LABEL, "Debtor Adjustment").toString());
        ObjectQuery query = Query.select(Shift.Properties.TRADING_DAY, "id").sum(DebtorPayment.Properties.AMOUNT, "price").linkUsing(DebtorPayment.Properties.SHIFT).linkUsing(DebtorPayment.Properties.FINANCE_TRANSACTION).linkUsing(Shift.Properties.TRADING_DAY).groupBy(Shift.Properties.TRADING_DAY).not().equals(FinanceTransaction.Properties.SUB_TYPE, accountSubType);
        this.getTDFilter().addQueryRestriction(query);
        if (!this.salesLocations.isEmpty()) {
            query.wherePropertyIn(FinanceTransaction.Properties.SALES_LOCATION, this.salesLocations);
        }
        if (this.groupByDayParts) {
            Object[][] results;
            query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("finance_transaction.timestamp"));
            query.groupBy("fk_config_day_part");
            for (Object[] nextResult : results = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new Object[0])) {
                Long id = MathsUtils.cantorPair(((Number)nextResult[0]).intValue(), Integer.parseInt((String)nextResult[2]));
                SATAReport bkReport = reportMap.get(id);
                bkReport.setDebtorPayments(bkReport.getDebtorPayments().add(new Price(((Number)nextResult[1]).doubleValue(), 0.01)));
            }
        } else {
            List<PriceReport> reports = PersistenceManager.getObjectList(PriceReport.class, query.toString());
            for (PriceReport nextReport : reports) {
                SATAReport bkReport = reportMap.get(nextReport.getID());
                bkReport.setDebtorPayments(bkReport.getDebtorPayments().add(nextReport.getPrice()));
            }
        }
    }

    private void populateDebtorSales(Map<Long, SATAReport> reportMap) {
        if (this.groupByDayParts) {
            ObjectQuery query = Query.select(DebtorSale.class).linkUsing(DebtorSale.Properties.SHIFT).linkUsing(Shift.Properties.TRADING_DAY);
            this.getTDFilter().addQueryRestriction(query);
            List<DebtorSale> sales = PersistenceManager.getObjectList(DebtorSale.class, query.toString());
            for (DebtorSale sale : sales) {
                SalesItemQuantity qty = sale.getSaleAccount().getAllItems().get(0).getSalesItemQuantities().get(0);
                if (!this.salesLocations.isEmpty() && !this.salesLocations.contains(qty.getSalesLocation())) continue;
                Long id = SATAReport.createId(sale.getShift().getTradingDay(), DayPart.getDayPart(sale.getSaleAccount().getClosedDateTime()));
                SATAReport bkReport = reportMap.get(id);
                bkReport.setDebtorSales(bkReport.getDebtorSales().add(sale.getTotal()));
            }
        } else {
            ObjectQuery query = Query.select(Shift.Properties.TRADING_DAY, "id").sum(DebtorSale.Properties.TOTAL, "price").linkUsing(DebtorSale.Properties.SHIFT).linkUsing(Shift.Properties.TRADING_DAY).groupBy(Shift.Properties.TRADING_DAY);
            this.getTDFilter().addQueryRestriction(query);
            List<PriceReport> reports = PersistenceManager.getObjectList(PriceReport.class, query.toString());
            for (PriceReport nextReport : reports) {
                SATAReport bkReport = reportMap.get(nextReport.getID());
                bkReport.setDebtorSales(bkReport.getDebtorSales().add(nextReport.getPrice()));
            }
        }
    }
}

