/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import java.util.Arrays;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.reports.sata.PaymentByTypeSearcher;

class EftposPerCDSearcher
extends PaymentByTypeSearcher {
    @Override
    public ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.sum(FinanceTransaction.Properties.PAID, "total").select(FinanceTransaction.Properties.TRADING_DAY).select(FinanceTransaction.Properties.SUB_TYPE).select(FinanceTransaction.Properties.CASH_DRAWER).active(FinanceTransaction.class).wherePropertyIn(FinanceUnit.Properties.TYPE, Arrays.asList(FinanceUnit.CREDIT_TYPE, FinanceUnit.DEBIT_TYPE)).whereFunction(" finance_unit.Name in (" + this.getEftposUnits() + ")").linkUsing(FinanceTransaction.Properties.TRADING_DAY).linkUsing(FinanceTransaction.Properties.SUB_TYPE).linkUsing(FinanceTransaction.Properties.CASH_DRAWER).groupBy(FinanceTransaction.Properties.TRADING_DAY).groupBy(FinanceTransaction.Properties.CASH_DRAWER).orderBy(FinanceTransaction.Properties.TRADING_DAY);
        if (this.groupByDayPart) {
            query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("finance_transaction.timestamp"));
            query.groupBy("fk_config_day_part");
        } else {
            query.selectFunc("null as fk_config_day_part");
        }
        return query;
    }

    private String getEftposUnits() {
        StringBuilder eftposSB = new StringBuilder();
        for (FinanceUnit.EftposUnitType unit : FinanceUnit.EftposUnitType.values()) {
            eftposSB.append("'").append(unit.getUnitName()).append("'").append(",");
        }
        return eftposSB.toString().substring(0, eftposSB.length() - 1);
    }
}

