/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import java.util.Date;
import java.util.List;
import java.util.Map;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.SATAReport;

public class FirstSATACompiler
extends AbstractSATACompiler {
    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        List<Date> days = TradingDay.ReportDates.getTradingDaysBetween(this.getFrom(), this.getTo());
        if (this.groupByDayParts) {
            int part;
            List<DayPart> dayParts = DayPart.getAllDayParts(true);
            for (int i = 0; i < days.size(); ++i) {
                for (part = 0; part < dayParts.size(); ++part) {
                    TradingDay day = TradingDay.ReportDates.getLastTradingDayForDate(days.get(i));
                    SATAReport report = new SATAReport(day, dayParts.get(part));
                    reportMap.put(report.getID(), report);
                }
            }
            TradingDay lastDay = TradingDay.ReportDates.getLastTradingDayForDate(this.getTo());
            if (!days.contains(lastDay.getDate())) {
                for (part = 0; part < dayParts.size(); ++part) {
                    SATAReport report = new SATAReport(lastDay, dayParts.get(part));
                    reportMap.put(report.getID(), report);
                }
            }
        } else {
            for (int i = 0; i < days.size(); ++i) {
                TradingDay day = TradingDay.ReportDates.getLastTradingDayForDate(days.get(i));
                SATAReport report = new SATAReport(day, null);
                reportMap.put(report.getID(), report);
            }
            TradingDay lastDay = TradingDay.ReportDates.getLastTradingDayForDate(this.getTo());
            if (!days.contains(lastDay.getDate())) {
                reportMap.put(lastDay.getID(), new SATAReport(lastDay, null));
            }
        }
    }
}

