/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import java.util.List;
import java.util.Map;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.searchers.reports.vouchers.VoucherTransactionSearcher;

public class GiftVoucherSalesCompiler
extends AbstractSATACompiler {
    private VoucherTransactionSearcher searcher = new VoucherTransactionSearcher();

    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        this.searcher.getTradingDayDateRangeFilter().setStart(this.getFrom());
        this.searcher.getTradingDayDateRangeFilter().setEnd(this.getTo());
        this.searcher.getSalesLocationFilter().setSearchOptions(this.salesLocations);
        List transactions = this.searcher.search();
        for (GiftVoucherTransaction txn : transactions) {
            Long id = this.groupByDayParts ? SATAReport.createId(txn.getTradingDay(), DayPart.getDayPart(txn.getCreationDate())) : txn.getTradingDay().getID();
            if (txn.isRedeeming()) {
                reportMap.get(id).addVoucherRedeem(txn.getAmount().negate());
                continue;
            }
            if (txn.isTopup()) {
                reportMap.get(id).addVoucherTopup(txn.getAmount());
                continue;
            }
            if (txn.isTopupReversal()) {
                reportMap.get(id).addVoucherTopupReversal(txn.getAmount());
                continue;
            }
            if (!txn.isRedeemReversal()) continue;
            reportMap.get(id).addVoucherRedeemReversal(txn.getAmount());
        }
    }
}

