/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.general.PriceReport;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class GrossSalesCompiler
extends AbstractSATACompiler {
    private GrossSalesReportSearcher searcher = new GrossSalesReportSearcher();

    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        this.searcher.getTradingDayFilter().setStart(this.getFrom());
        this.searcher.getTradingDayFilter().setEnd(this.getTo());
        if (this.groupByDayParts) {
            Object[][] results;
            ObjectQuery query = this.searcher.getObjectQuery();
            for (Object[] nextResult : results = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), new Object[0])) {
                Long id = MathsUtils.cantorPair(((Number)nextResult[0]).intValue(), Integer.parseInt((String)nextResult[1]));
                reportMap.get(id).addGrossSales(new Price(((Number)nextResult[2]).doubleValue(), 0.01));
            }
        } else {
            List reports = this.searcher.search();
            for (PriceReport report : reports) {
                reportMap.get(report.getID()).addGrossSales(report.getPrice());
            }
        }
    }

    class GrossSalesReportSearcher
    extends PropertySearcher<PriceReport> {
        private RangeQuerySearchFilter<Date> tradingDayFilter;
        private MultiOptionSearchFilter salesLocationFilter;

        public GrossSalesReportSearcher() {
            super(PriceReport.class);
            this.tradingDayFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP);
            this.addSearchFilter(new TradingDayDateRangeFilterAdapter(this.tradingDayFilter));
            this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
            this.addSearchFilter(this.salesLocationFilter);
        }

        @Override
        public ObjectQuery getBaseQuery() {
            ObjectQuery query;
            if (GrossSalesCompiler.this.siqTradingDay) {
                query = Query.select(SalesItemQuantity.Properties.TRADING_DAY, "ID");
                if (GrossSalesCompiler.this.groupByDayParts) {
                    query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("sales_item_quantity.creation_time"));
                    query.groupBy("fk_config_day_part");
                } else {
                    query.selectFunc("0 as fk_config_day_part");
                }
                query.selectFunc("SUM(" + SalesComponent.Properties.SAVED_UNIT_PRICE + " * " + SalesItemQuantity.Properties.QUANTITY + ") AS 'Price' ").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItemQuantity.Properties.TRADING_DAY).linkUsing(SalesComponent.Properties.SALES_ITEM).groupBy(SalesItemQuantity.Properties.TRADING_DAY);
                this.salesLocationFilter.setSearchOptions(GrossSalesCompiler.this.salesLocations);
            } else {
                this.salesLocationFilter.clearSearch();
                query = Query.select(Account.Properties.TRADING_DAY, "ID").selectFunc("0 as 'fk_config_day_part'").selectFunc("SUM(" + SalesComponent.Properties.SAVED_UNIT_PRICE + " * " + SalesItemQuantity.Properties.QUANTITY + ") AS 'Price' ").linkUsing(Account.Properties.TRADING_DAY).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM).groupBy(Account.Properties.TRADING_DAY);
            }
            return query;
        }

        RangeQuerySearchFilter<Date> getTradingDayFilter() {
            return this.tradingDayFilter;
        }
    }
}

