/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.queries.hardware.CashDrawerQueries;
import ordermate.database.reports.finance.FinanceUnitTotalsReport;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.EftposPerCDSearcher;
import ordermate.database.reports.sata.PaymentByTypeSearcher;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.SATAReportColumns;
import ordermate.database.reports.sata.SATAReportProperties;

class PaymentByTypeCompiler
extends AbstractSATACompiler {
    private PaymentByTypeSearcher searcher = new PaymentByTypeSearcher();
    private EftposPerCDSearcher eftposCDSearcher = new EftposPerCDSearcher();
    private boolean totalEftposPerCD;

    PaymentByTypeCompiler() {
    }

    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        this.totalEftposPerCD = SATAReportProperties.isTotalEftposPerCashdrawer();
        this.searcher.getTradingDayFilter().setStart(this.getFrom());
        this.searcher.getTradingDayFilter().setEnd(this.getTo());
        this.searcher.setGroupByDayPart(this.groupByDayParts);
        this.searcher.salesLocationFilter.setSearchOptions(this.salesLocations);
        this.eftposCDSearcher.getTradingDayFilter().setStart(this.getFrom());
        this.eftposCDSearcher.getTradingDayFilter().setEnd(this.getTo());
        this.eftposCDSearcher.setGroupByDayPart(this.groupByDayParts);
        List<CashDrawer> allActiveCDs = CashDrawerQueries.getAllCashdrawers();
        if (this.totalEftposPerCD) {
            List eftposPerCD = this.eftposCDSearcher.search();
            if (allActiveCDs != null) {
                for (CashDrawer cd : allActiveCDs) {
                    for (SATAReport report : reportMap.values()) {
                        report.getFinancePayments().add(new Pair<String, Price>(SATAReportColumns.EFTPOS_PREFIX.getName() + cd.getLabel(), Price.ZERO_NO_ROUND));
                    }
                }
                for (FinanceUnitTotalsReport total : eftposPerCD) {
                    int idx = allActiveCDs.indexOf(total.getCashDrawer());
                    SATAReport sataReport = reportMap.get(SATAReport.createId(total.getTradingDay(), total.getDayPart()));
                    Pair<String, Price> perCDReport = sataReport.getFinancePayments().get(idx);
                    perCDReport.setValue(perCDReport.getValue().add(total.getTotal()));
                }
            }
        }
        ArrayList<FinanceUnit> units = new ArrayList<FinanceUnit>();
        if (!SATAReportProperties.getHiddenColumns().contains(FinanceUnit.getDefaultUnitFor(FinanceUnit.CASH_TYPE).getLabel())) {
            units.add(FinanceUnit.getDefaultUnitFor(FinanceUnit.CASH_TYPE));
        }
        this.initPayments(this.totalEftposPerCD, units, reportMap);
        List totalsPerType = this.searcher.search();
        int offset = 0;
        if (this.totalEftposPerCD) {
            offset = allActiveCDs != null ? allActiveCDs.size() : 0;
        }
        for (FinanceUnitTotalsReport total : totalsPerType) {
            int index;
            int unitsIdx = units.indexOf(total.getUnit());
            if (unitsIdx < 0 || (index = offset + units.indexOf(total.getUnit())) < offset) continue;
            SATAReport sataReport = reportMap.get(SATAReport.createId(total.getTradingDay(), total.getDayPart()));
            Pair<String, Price> miniReport = sataReport.getFinancePayments().get(index);
            miniReport.setValue(miniReport.getValue().add(total.getTotal()));
        }
    }
}

