/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.finance.FinanceUnitTotalsReport;

class PaymentByTypeSearcher
extends PropertySearcher<FinanceUnitTotalsReport> {
    private IRangedQuerySearchFilter<Date> tradingDayFilter;
    MultiOptionSearchFilter terminalLocationFilter;
    MultiOptionSearchFilter salesLocationFilter;
    protected boolean groupByDayPart;

    public PaymentByTypeSearcher() {
        super(FinanceUnitTotalsReport.class);
        this.tradingDayFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE);
        this.terminalLocationFilter = new MultiOptionSearchFilter<TerminalLocation>(FinanceTransaction.Properties.LOCATION);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(FinanceTransaction.Properties.SALES_LOCATION);
        this.groupByDayPart = false;
        this.addSearchFilter(new TradingDayDateRangeFilterAdapter(this.tradingDayFilter));
        this.addSearchFilter(this.terminalLocationFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    void setGroupByDayPart(boolean value) {
        this.groupByDayPart = value;
    }

    @Override
    public ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.sum(FinanceTransaction.Properties.PAID, "total").select(FinanceTransaction.Properties.TRADING_DAY).select(FinanceTransaction.Properties.SUB_TYPE).select(FinanceTransaction.Properties.CASH_DRAWER).active(FinanceTransaction.class).linkUsing(FinanceTransaction.Properties.CASH_DRAWER).groupBy(FinanceTransaction.Properties.TRADING_DAY).groupBy(FinanceTransaction.Properties.SUB_TYPE).orderBy(FinanceTransaction.Properties.TRADING_DAY).orderBy(FinanceTransaction.Properties.SUB_TYPE);
        if (this.tradingDayFilter.hasSearchValue()) {
            query.linkUsing(FinanceTransaction.Properties.TRADING_DAY);
        }
        if (this.groupByDayPart) {
            query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("finance_transaction.timestamp"));
            query.groupBy("fk_config_day_part");
        } else {
            query.selectFunc("null as fk_config_day_part");
        }
        return query;
    }
}

